<?php

use App\Http\Controllers\Admin\ClearCacheController;
use Illuminate\Support\Facades\Route;
use App\Models\Settings;
use Laravel\Fortify\Http\Controllers\NewPasswordController;
use App\Http\Controllers\HomePageController;
use App\Http\Controllers\TradeController;
use App\Http\Controllers\CryptoPriceController;
use App\Http\Controllers\WalletController;
use App\Http\Controllers\BlogController;
use App\Http\Controllers\User\VerifyController;
use App\Services\TatumService;
use App\Http\Controllers\Auth\LoginController;
use App\Http\Controllers\Auth\RegisterController;
use App\Http\Controllers\Auth\PasswordResetController;
use App\Http\Controllers\Auth\ResetPasswordController;
use App\Http\Controllers\CurrencyController;
use App\Services\PaystackService;

/* 
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

require __DIR__ . '/admin/web.php';
require __DIR__ . '/user/web.php';




Route::post('/password/reset', [ResetPasswordController::class, 'reset'])->name('password.update');
Route::post('/register', [RegisterController::class, 'register'])->name('register');
Route::post('/login', [LoginController::class, 'login'])->name('login');
Route::post('/otp-verify', [LoginController::class, 'verifyOtp'])->name('otp.verify');
Route::get('otp', [LoginController::class, 'otp'])->name('otp');
Route::get('/2fa/setup', [LoginController::class, 'enableGoogle2FA'])->name('2fa.setup');
Route::post('/2fa/verify', [LoginController::class, 'verify2FA'])->name('verify.2fa');


Route::get('/prices', [CryptoPriceController::class, 'updatePrices']);
Route::get('/rates', [CurrencyController::class, 'fetchAndStoreFreaksRates']);


//activate and deactivate Online Trader
Route::any('/activate', function () {
	return view('activate.index', [
		'settings' => Settings::where('id', '1')->first(),
	]);
});

Route::get('register-license', [ClearCacheController::class, 'saveLicense']);

Route::any('/revoke', function () {
	return view('revoke.index');
});

Route::post('/password/email', [PasswordResetController::class, 'sendResetLinkEmail'])->name('password.email');

//cron url

//Front Pages Route
Route::get('/', [HomePageController::class, 'index'])->name('home');
Route::get('index', [HomePageController::class, 'index'])->name('home');
Route::get('terms', [HomePageController::class, 'terms'] )->name('terms');
Route::get('privacy',[HomePageController::class, 'privacy'])->name('privacy');
Route::get('about', [HomePageController::class, 'about'])->name('about');
Route::get('contact',[HomePageController::class, 'contact'])->name('contact');
Route::post('sendcontact',[HomePageController::class, 'sendcontact'])->name('sendcontact');