@extends('layouts.muladash')
@section('title', $title)
@section('content')

    <x-danger-alert />
    <x-success-alert />

    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
        <div class="px-6 flex justify-between items-center pb-8">
            <a href="javascript:history.back()" class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white">
                <i class="ph ph-caret-left"></i>
            </a>
            <div class="flex-1 flex justify-center items-center pr-12">
                <p class="text-2xl font-semibold">Update Bank Information</p>
            </div>
        </div>

        <form id="updateBankForm" action="{{ route('saveAccount') }}" class="flex flex-col gap-4 pt-8 px-6">
            <input type="" id="bank_name" name="bank_name" >
            <!-- Bank Dropdown -->
            <div class="flex flex-col justify-start">
                <label for="bank_code" class="text-sm font-semibold pb-2 dark:text-white">Select Bank</label>
                <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <select id="bank_code" name="bank_code" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white">
                        <option value="">Select Bank</option>
                        @foreach($banks as $bank)
                            <option value="{{ $bank->code }}">{{ $bank->name }}</option>
                        @endforeach
                    </select>
                </div>
            </div>

            <!-- Account Number -->
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Account Number</p>
                <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <input type="text" id="account_number" name="account_number" maxlength="10" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" />
                </div>
            </div>

            <!-- Account Name (Read-Only) -->
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Account Name</p>
                <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <input readonly type="text" id="account_name" name="account_name" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" />
                </div>
            </div>

            <!-- Save Account Button -->
            <div class="bottom-0 my-3 flex">
                <button type="button" id="saveAccountBtn" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">
                    Save New Account
                </button>
            </div>
        </form>
    </main>

@endsection


@section('scripts')

<script>
$(document).ready(function(){
    // Function to verify the account details via AJAX.
    function verifyAccount(){
        var bankCode = $('#bank_code').val();
        var accountNumber = $('#account_number').val();
        
        // Only trigger the API call if a bank is selected and the account number has exactly 11 digits.
        if(bankCode && accountNumber.length === 10) {
            $.ajax({
                url: '{{ route("resolveAccount") }}',  // Laravel route for account resolution.
                type: 'POST',
                data: {
                    bank_code: bankCode,
                    account_number: accountNumber,
                    _token: '{{ csrf_token() }}'
                },
                success: function(response){
                    if(response.account_name){
                        // Populate the read-only field with the resolved account name.
                        $('#account_name').val(response.account_name);
                    } else {
                        toastr.error('Unable to resolve account. Please verify your details.');
                    }
                },
                error: function(xhr){
                    console.log(xhr.responseText);
                    toastr.error('An error occurred while verifying your account.');
                }
            });
        }
    }
    
    // Trigger the verification automatically when the account number reaches 11 digits.
    $('#account_number').on('keyup', function(){
        var accountNumber = $(this).val();
        if(accountNumber.length === 10) {
            verifyAccount();
        }
    });
    
    // Also trigger verification when the bank selection changes
    // (if the account number is already complete).
    $('#bank_code').on('change', function(){
        var accountNumber = $('#account_number').val();
        if(accountNumber.length === 10) {
            verifyAccount();
        }
    });

    // Process the save account action once the "Save Account" button is clicked.
    $('#saveAccountBtn').on('click', function(){
        var bankCode = $('#bank_code').val();
        var accountNumber = $('#account_number').val();

        if(bankCode && accountNumber.length === 10) {
            $.ajax({
                url: '{{ route("saveAccount") }}',  // Laravel route for saving the account details.
                type: 'POST',
                data: {
                    bank_code: bankCode,
                    account_number: accountNumber,
                    bank_name: $('#bank_name').val(), // Include bank_name
                    _token: '{{ csrf_token() }}'
                },
                success: function(response){
                    if(response.message){
                        toastr.success(response.message);
                        setTimeout(function() {
                            window.location.href = response.redirect || '{{ route('profile') }}';
                        }, 3000);
                    } else if(response.error){
                        toastr.error(response.error);
                    }
                },
                error: function(xhr){
                    console.log(xhr.responseText);
                    toastr.error('Account Name Mismatch.');
                }
            });
        } else {
            toastr.error('Please select a bank and enter a valid 11-digit account number.');
        }
    });
});
</script>
<script>
    $(document).ready(function(){
        // When the bank is selected, update the hidden bank_name field.
        $('#bank_code').on('change', function() {
            var bankName = $("#bank_code option:selected").text();
            $('#bank_name').val(bankName);
        });
    });
    </script>
@endsection
