@extends('layouts.muladash')
@section('title', $title)
@section('content')



		<x-danger-alert />
		<x-success-alert />
		 

		 <div class="row">
			

            <div class="col-xl-12 col-lg-12"> 
                <div class="card">
                    <div class="card-header justify-content-between border-0 pb-2 flex-wrap">
                        <h4 class="heading me-2">Trading History</h4>

						<nav>
							<div class="order nav nav-tabs" id="nav-tab" role="tablist">
								<button class="nav-link active" id="all-tab" data-bs-toggle="tab"
									data-bs-target="#all" type="button" role="tab" aria-selected="true">All</button>
						
								<button class="nav-link" id="buy-tab" data-bs-toggle="tab"
									data-bs-target="#buy" type="button" role="tab" aria-selected="false">Buy</button>
						
								<button class="nav-link" id="sell-tab" data-bs-toggle="tab" 
									data-bs-target="#sell" type="button" role="tab" aria-selected="false">Sell</button>
						
								<button class="nav-link" id="win-tab" data-bs-toggle="tab"
									data-bs-target="#win" type="button" role="tab" aria-selected="false">Win</button>
						
								<button class="nav-link" id="loss-tab" data-bs-toggle="tab"
									data-bs-target="#loss" type="button" role="tab" aria-selected="false">Loss</button>
							</div>
						</nav>

                    </div>
                    <div class="card-body px-0 py-0">

						
<div class="tab-content" id="nav-tabContent">
    <div class="tab-pane fade show active" id="all" role="tabpanel" aria-labelledby="all-tab">
        <div class="table-responsive">
            <table class="table shadow-hover display" id="example6">
                <thead>
                    <tr>
                        <th class="border-0">
                        
                        </th>
                        <th class="fs-14 font-w600 border-0 ps-0">Detail</th>
                        <th class="fs-14 font-w600 border-0">Trade</th>
                        <th class="fs-14 font-w600 border-0">Status</th>
                        <th class="fs-14 font-w600 border-0">Date</th>
                        
                    
                    </tr>
                </thead>
                <tbody>
                    @forelse($t_history as $history)
                        @if($history->type == 'LOSE')
                        <tr>
                            <td>
                                <div class="checkbox me-0 align-self-center">
                                    <div class="custom-control custom-checkbox "></div>
                                </div>
                            </td>
                            <td class="ps-0">
                                <p class="mb-0 text-danger">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                                <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="">
                                        <span class="font-w600 fs-14 text-white label label-danger">LOST</span>
                                        <span class="font-w600 fs-14 text-white label label-danger">-{{ $history->leverage }}%</span>
                                        
                                    </div>
                                </div>
                            </td>
                            <td class="">
                                <h5 class="mb-0"><a class="text-secondary font-w600 fs-14 text-white label label-dark"
                                        href="">Expired</a></h5>
                            </td>
                            <td><p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                        </tr>
                
                        @elseif($history->type == 'WIN')
                        <tr>
                            <td>
                                <div class="checkbox me-0 align-self-center">
                                    <div class="custom-control custom-checkbox "></div>
                                </div>
                            </td>
                            <td class="ps-0">
                                <p class="mb-0 text-success">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                                <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="">
                                        <span class="font-w600 fs-14 text-white label label-success">Win</span>
                                        <span class="font-w600 fs-14 text-white label label-success">+{{ $history->leverage }}%</span>
                                        
                                    </div>
                                </div>
                            </td>
                            <td class="">
                                <span class="font-w600 fs-14 text-white label label-dark">Expired</span>
                            </td>
                            <td><p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                        </tr>
                
                        @elseif($history->type == 'Buy')
                        <tr>
                            <td>
                                <div class="checkbox me-0 align-self-center">
                                    <div class="custom-control custom-checkbox "></div>
                                </div>
                            </td>
                            <td class="ps-0">
                                <p class="mb-0 text-success">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                                <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="">
                                        <span class="font-w600 fs-14 text-white label label-success">{{ $history->type }}</span>
                                        <span class="fs-14 ">Leverage:1:{{ $history->leverage }}</span>
                                        
                                    </div>
                                </div>
                            </td>
                            <td class="">
                                <span class="font-w600 fs-14 text-white label label-success">Buy</span>
                            </td>
                            <td><p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                        </tr>
                
                        @elseif($history->type == 'Sell')
                        <tr>
                            <td>
                                <div class="checkbox me-0 align-self-center">
                                    <div class="custom-control custom-checkbox "></div>
                                </div>
                            </td>
                            <td class="ps-0">
                                <p class="mb-0 text-danger">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                                <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="">
                                        <span class="font-w600 fs-14 text-white label label-danger">{{ $history->type }}</span>
                                        <span class="fs-14 ">Leverage:1:{{ $history->leverage }}</span>
                                        
                                    </div>
                                </div>
                            </td>
                            <td class="">
                                <span class="font-w600 fs-14 text-white label label-danger">Sell</span>
                            </td>

                            <td><p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                        </tr>
                
                        @endif
                    @empty
                        <tr>
                            <td colspan="10" class="text-center">
                                No Data Available
                            </td>
                        </tr>
                    @endforelse
                </tbody>
            </table>
        </div>
    </div>

    <!-- Buy Tab -->
    <div class="tab-pane fade" id="buy" role="tabpanel" aria-labelledby="buy-tab">
        <div class="table-responsive">
            <table class="table shadow-hover display" id="example6">
                <thead>
                    <tr>
                        <th class="border-0"></th>
                        <th class="fs-14 font-w600 border-0 ps-0">Detail</th>
													<th class="fs-14 font-w600 border-0">Trade</th>
													<th class="fs-14 font-w600 border-0">Status</th>
													<th class="fs-14 font-w600 border-0">Date</th>
                    </tr>
                </thead>
                <tbody>

                    @if ($t_history->isEmpty())
                    <tr>
                        <td colspan="4" class="text-center">No data available</td>
                    </tr>
                @else

                    @foreach($t_history as $history)
                        @if($history->type == 'Buy')
                        <tr>
                            <td></td>
                            <td class="ps-0">
                                <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                                <p class="mb-0 text-success">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                            </td>
                            <td>
                                <div class="d-flex align-items-center">
                                    <div class="ms-3">
                                        <span class="font-w600 fs-14 text-white label label-success">{{ $history->type }}</span>
                                        <span class="fs-14 ">Leverage:1:{{ $history->leverage }}</span>
                                       
                                    </div>
                                </div>
                            </td>
                            <td>
                                <span class="font-w600 fs-14 text-white label label-success">Buy</span>
                            </td>
                            <td> <p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                        </tr>
                        @endif
                    @endforeach
                    @endif
                </tbody>
            </table>
        </div>
    </div>

    <!-- Additional tabs for Sell, Win, and Loss -->
  <!-- Sell Tab -->
<div class="tab-pane fade" id="sell" role="tabpanel" aria-labelledby="sell-tab">
    <div class="table-responsive">
        <table class="table shadow-hover display" id="example6">
            <thead>
                <tr>
                    <th class="border-0"></th>
                    <th class="fs-14 font-w600 border-0 ps-0">Detail</th>
													<th class="fs-14 font-w600 border-0">Trade</th>
													<th class="fs-14 font-w600 border-0">Status</th>
													<th class="fs-14 font-w600 border-0">Date</th>
                </tr>
            </thead>
            <tbody>

                @if ($t_history->isEmpty())
                <tr>
                    <td colspan="4" class="text-center">No data available</td>
                </tr>
            @else


                @foreach($t_history as $history)
                    @if($history->type == 'Sell')
                    <tr>
                        <td>
                            <div class="checkbox me-0 align-self-center"></div>
                        </td>
                        <td class="ps-0">
                            <p class="mb-0 text-danger">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                            <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="ms-3">
                                    <span class="font-w600 fs-14 text-white label label-danger">{{ $history->type }}</span>
                                    <span class="fs-14 ">Leverage:1:{{ $history->leverage }}</span>
                                   
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="font-w600 fs-14 text-white label label-danger">Sell</span>
                        </td>
                        <td> <p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                    </tr>
                    @endif
                @endforeach
                @endif
            </tbody>
        </table>
    </div>
</div>

<!-- Win Tab -->
<div class="tab-pane fade" id="win" role="tabpanel" aria-labelledby="win-tab">
    <div class="table-responsive">
        <table class="table shadow-hover display" id="example6">
            <thead>
                <tr>
                    <th class="border-0"></th>
                    <th class="fs-14 font-w600 border-0 ps-0">Detail</th>
													<th class="fs-14 font-w600 border-0">Trade</th>
													<th class="fs-14 font-w600 border-0">Status</th>
													<th class="fs-14 font-w600 border-0">Date</th>
                </tr>
            </thead>
            <tbody>

                @if ($t_history->isEmpty())
                <tr>
                    <td colspan="4" class="text-center">No data available</td>
                </tr>
            @else

                @foreach($t_history as $history)
                    @if($history->type == 'WIN')
                    <tr>
                        <td>
                            <div class="checkbox me-0 align-self-center"></div>
                        </td>
                        <td class="ps-0">
                            <p class="mb-0 text-success">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                            <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="ms-3">
                                    <span class="font-w600 fs-14 text-white label label-success">Win</span> 
                                    <span class="font-w600 fs-14 text-white label label-success">+{{ $history->leverage }}%</span>
                                 
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="font-w600 fs-14 text-white label label-success">Win</span>
                        </td>
                        <td> <p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                    </tr>
                    @endif
                @endforeach
                @endif
            </tbody>
        </table>
    </div>
</div>

<!-- Loss Tab -->
<div class="tab-pane fade" id="loss" role="tabpanel" aria-labelledby="loss-tab">
    <div class="table-responsive">
        <table class="table shadow-hover display" id="example6">
            <thead>
                <tr>
                    <th class="border-0"></th>
                    <th class="fs-14 font-w600 border-0 ps-0">Detail</th>
													<th class="fs-14 font-w600 border-0">Trade</th>
													<th class="fs-14 font-w600 border-0">Status</th>
													<th class="fs-14 font-w600 border-0">Date</th>
                </tr>
            </thead>
            <tbody>

                @if ($t_history->isEmpty())
                <tr>
                    <td colspan="4" class="text-center">No data available</td>
                </tr>
            @else

                @foreach($t_history as $history)
                    @if($history->type == 'LOSE')
                    <tr>
                        <td>
                            <div class="checkbox me-0 align-self-center"></div>
                        </td>
                        <td class="ps-0">
                            <p class="mb-0 text-danger">{{ Auth::user()->currency }}{{ $history->amount }}</p>
                            <span class="font-w600 fs-14"> {{ $history->plan }} </span>
                        </td>
                        <td>
                            <div class="d-flex align-items-center">
                                <div class="ms-3">
                                    <span class="font-w600 fs-14 text-white label label-danger">LOST</span> 
                                    <span class="font-w600 fs-14 text-white label label-danger">-{{ $history->leverage }}%</span>
                                
                                </div>
                            </div>
                        </td>
                        <td>
                            <span class="font-w600 fs-14 text-white label label-dark">Expired</span>
                        </td>

                        <td><p class="mb-0">{{ $history->created_at->toDayDateTimeString() }}</p></td>
                    </tr>
                    @endif
                @endforeach
                @endif
            </tbody>
        </table>
    </div>
</div>

</div>

                            
                        </div>
                        
                       <div style="margin:20px;">
                                {{ $t_history->links() }}
                            </div>
                    </div>
                </div>
            </div>
			


		

</div></div></div>

@endsection
