@extends('layouts.muladash')
@section('title', $title)
@section('content')



		<x-danger-alert />
		<x-success-alert />

    @if ( $currency_symbol == 'USD')

    <main
    class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh pb-32"
  >
    <div class="px-6 flex justify-between items-center">
      <a href="javascript:history.back()"
        class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
      >
        <i class="ph ph-caret-left"></i>
      </a>
      <div class="flex-1 flex justify-center items-center pr-12">
        <p class="text-2xl font-semibold">Topup {{ $currency_name }} Wallet</p>
      </div>
    </div>
    <div class="flex justify-between items-center gap-4 px-6 pt-8">
    <div class="flex-1">
     
        <div
          class="bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 flex gap-2 px-4 py-3 rounded-2xl"
        >
          <div
            class="bg-white box-shadow size-8 rounded-full flex justify-center items-center"
          >
            <img src="{{ asset('storage/' . $logo) }}" alt="" />
          </div>
          <div class="">
            <p class="text-sm font-semibold">1 {{ $currency_symbol }} = {{ $crypto_price ? number_format($crypto_price, 2) : 'N/A' }}</p>
            <p class="text-n500 dark:text-darkN500 pt-2 text-xs">
             Waiting to Receive
            </p>
          </div>
        </div>
      </div>
    </div>


    </main>
          
    @else
    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
      <div class="px-6 flex justify-between items-center">
          <a href="javascript:history.back()"
            class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
          >
            <i class="ph ph-caret-left"></i>
          </a>
          <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">Topup {{ $currency_name }} Wallet</p>
          </div>
        </div>







        <div class="flex justify-between items-center gap-4 px-6 pt-8">
        <div class="flex-1">
         
            <div
              class="bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 flex gap-2 px-4 py-3 rounded-2xl"
            >
              <div
                class="bg-white box-shadow size-8 rounded-full flex justify-center items-center"
              >
                <img src="{{ asset('storage/' . $logo) }}" alt="" />
              </div>
              <div class="">
                <p class="text-sm font-semibold">1 {{ $currency_symbol }} = {{ $crypto_price ? number_format($crypto_price, 2) : 'N/A' }}</p>
                <p class="text-n500 dark:text-darkN500 pt-2 text-xs">
                 Waiting to Receive
                </p>
              </div>
            </div>
          </div>
        </div>

        <div class="px-6 pt-8 flex justify-center items-center">
          <div class="bg-n20 p-6 rounded-xl dark:bg-darkN20 w-full">
           <!-- <img
              src="/muladash/assets/images/qr-code.png"
              alt=""
              class="dark:hidden w-full"
            />
            <img
              src="/muladash/assets/images/qr-code-white.png"
              alt=""
              class="hidden dark:block w-full"
            />-->
            {!! QrCode::size(330)->generate($wallet_address); !!}


          </div>
        </div>

        <div class="pt-8">
            <div
              class="border border-n40 dark:border-darkN40 flex flex-col gap-5 p-4 mx-6 rounded-2xl"
            >
            <div class="flex justify-between items-center">
                <p class="text-sm text-n500 dark:text-darkN500 wallet-address">{{ $wallet_address }}</p>
                
              </div>

              <div
              class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
            >
              <p class="text-sm text-n500 dark:text-darkN500">Amount</p>
              <p class="text-sm">{{ $settings->currency }}{{ $amount }}</p>
            </div>
    
              <div
                class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
              >
                <p class="text-sm text-n500 dark:text-darkN500">Wallet Network</p>
                <p class="text-sm">{{ $currency_symbol }}</p>
              </div>

              <div
              class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
            >
              <p class="text-sm text-n500 dark:text-darkN500">Estimated Confirmations</p>
              <p class="text-sm">3 Blockchain</p>
            </div>

            <div
            class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
          >
            <p class="text-sm text-n500 dark:text-darkN500">Estimated Confirmation time</p>
            <p class="text-sm">Less than 15 Minutes</p>
          </div>
              
            </div>
          </div>
  
        <div
          class="fixed bottom-10 left-0 right-0 flex justify-center items-center gap-4"
        >
         
        <button class="w-12 h-12 rounded-full bg-g300 flex justify-center items-center text-white copy-btn">
            <i class="ph ph-copy ph-folder text-xl !leading-none"></i>
          </button>
          
        </div>

        <div class="px-6 py-8">
          <div class="flex justify-between items-center gap-4">
            <a
              href="javascript:history.back()"
              class="flex-1 py-3 bg-bgColor text-g300 font-medium text-center rounded-xl border border-bgColor2 dark:bg-darkN20 dark:border-darkN40"
              >Cancel Topup</a
            >
            <a
              class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300 contactSavedConfirmationModalOpenButton"
              >Process</a
            >
          </div>
        </div>


        <!-- Contact Saved Confirmation Modal Start  -->
			   <form method="POST" action="{{ route('savedeposit') }}" id="deposit-form">
          @csrf
      <div
    class="contactSavedConfirmationModal container fixed inset-0 z-30 popup-modal"
    >
    <div
      class="modalBg absolute inset-0 bg-black opacity-30 dark:bg-white"
    ></div>
    <div
      class="modal relative z-10 flex h-full flex-col items-center justify-center px-6 text-center"
    >
      <div class="rounded-2xl bg-white p-7 dark:bg-n0 w-full">
    
    
      <div class="flex flex-col justify-start">
        
        <div
          class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl"
        >
          <input
          type="text" name="hash"
          placeholder="Transaction Hash"
          class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white"
          />
  
          <input type="hidden" name="payment_mode" value="{{ $payment_mode }}">
          <input type="hidden" name="currency_id" value="{{ $currency_id }}">
        
  
        </div>
        </div>
      <div class="flex justify-between items-center gap-4 pt-5">
        
        <a href="javascript:history.back()"
        class="flex-1 py-3 bg-bgColor text-g300 font-medium text-center rounded-xl border border-bgColor2 dark:bg-darkN20 dark:border-darkN40 "
      >
        Cancel
      </a>
        <button type="submit"
    
        class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
        >Proceed</button
        >
      </div>
      </div>
    </div>
    </div>
           </form>
    <!-- Contact Saved Confirmation Modal End -->


      </main>

      @endif

@endsection
@section('scripts')
<script>
    document.addEventListener('DOMContentLoaded', function() {
      // Set global Toastr options (optional)
      toastr.options = {
        timeOut: 3500,
        progressBar: true
      };
    
      document.querySelector('.copy-btn').addEventListener('click', function() {
        // Get the wallet address text from the element with class 'wallet-address'
        var walletAddress = document.querySelector('.wallet-address').textContent.trim();
        console.log("Wallet Address to copy:", walletAddress);
        
        // Fallback method: Create a temporary input, copy its value, then remove it.
        var input = document.createElement("input");
        input.value = walletAddress;
        document.body.appendChild(input);
        input.select();
    
        try {
          var successful = document.execCommand("copy");
          if (successful) {
            toastr.success("Wallet copied", "Success");
          } else {
            toastr.error("Failed to copy wallet address", "Error");
          }
        } catch (error) {
          console.error("Copy failed:", error);
          toastr.error("Failed to copy wallet address", "Error");
        }
        
        document.body.removeChild(input);
      });
    });
    </script>
    
@endsection
