@extends('layouts.muladash')
@section('title', $title)
@section('content')
<style>
    .contactSavedConfirmationModal {
        display: none;
    }
</style>

<x-danger-alert />
<x-success-alert />

<main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh pb-32">
    <div class="px-6 flex justify-between items-center">
        <a href="javascript:history.back()" class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl text-white">
            <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">Pay Bills</p>
        </div>
    </div>

    <div class="bg-white py-7 px-6 rounded-t-3xl dark:bg-n0">
        <div class="grid grid-cols-2 gap-4">
            @foreach ($bills as $bill)
            <a href="javascript:void(0);" 
               class="col-span-1 p-4 border rounded-2xl flex flex-col gap-3 items-center text-center openPayModal"
               data-target="#payModal-{{ $bill->id }}">
                <div class="bg-bgColor border rounded-full w-12 h-12 flex justify-center items-center">
                    <img src="{{ asset('storage/' . $bill->img) }}" alt="{{ $bill->name }}" />
                </div>
                <p class="text-sm font-semibold">{{ $bill->name }}</p>
            </a>
            @endforeach
        </div>
    </div>
</main>

<!-- Modals -->
@foreach ($bills as $bill)
<form class="billPaymentForm" action="{{ route('pay.bill') }}" method="POST">

    @csrf
<div class="contactSavedConfirmationModal container fixed inset-0 z-30" id="payModal-{{ $bill->id }}">
<div class="modalBg absolute inset-0 bg-black opacity-30"></div>
<div class="modal relative z-10 flex h-full flex-col items-center justify-center px-6 text-center">
  <div class="rounded-2xl bg-white p-7 dark:bg-n0 w-full">

    <p class="text-lg font-semibold">Pay for {{ $bill->name }}</p>

    {{-- Pay From --}}
    <div class="flex flex-col justify-start">
        <div class="relative">
            <div class="p-3 flex justify-between items-center gap-2 bg-n20 border rounded-xl cursor-pointer selectCountry">
                <div class="flex justify-start items-center gap-1">
                    <div class="size-7 flex justify-center items-center rounded-full bg-white dark:bg-darkG300">
                        <img id="selected_wallet_logo" src="{{ asset('storage/' . $userWalletsInUSD[0]['logo']) }}" alt="" class="w-[24px] h-[24px] object-cover" />
                    </div>
                    <p class="text-n90 text-sm dark:text-white selectedItem">
                       Pay from My {{ $userWalletsInUSD[0]['name'] }} Wallet
                    </p>
                </div>
                <i class="ph ph-caret-down text-n90 text-lg"></i>
            </div>

            <div class="selectCountryModal bg-white p-4 rounded-xl border w-full absolute right-0 top-14 max-h-[200px] overflow-y-auto invisible opacity-0 scale-75 duration-500">
                <ul class="flex flex-col gap-2">
                    @foreach($userWalletsInUSD as $wallet)
                        <li class="text-xs cursor-pointer item"
                            data-symbol="{{ $wallet['symbol'] }}"
                            data-name="{{ $wallet['name'] }}"
                            data-logo="{{ asset('storage/' . $wallet['logo']) }}">
                           Pay from My {{ $wallet['name'] }} Wallet ({{ $settings->currency }}{{ number_format($wallet['balance_in_usd'], 2) }})
                        </li>
                    @endforeach

                    @foreach($cards as $card)
                        <li class="text-xs cursor-pointer item"
                            data-symbol="card"
                            data-name="{{ strtoupper(str_replace('_', ' ', $card->card_type)) }} - ****{{ substr($card->cardnum, -4) }}"
                            data-logo="{{ asset('images/card-icon.png') }}">
                            {{ strtoupper(str_replace('_', ' ', $card->card_type)) }} - ****{{ substr($card->cardnum, -4) }}
                        </li>
                    @endforeach
                </ul>
            </div>
        </div>
    </div>

    {{-- Amount --}}
    <div class="flex flex-col justify-start mt-4">
        <p class="text-sm font-semibold pb-2 dark:text-white">Amount</p>
        <div class="p-4 bg-white border rounded-xl">
            <input type="number" name="amount" placeholder="0.00" class="w-full bg-transparent text-[32px] dark:text-white font-bold" required />
        </div>
    </div>

    {{-- Dynamic Bill Fields --}}
    @if(in_array($bill->name, ['Electricity', 'Water Bill', 'Internet', 'Cable']))
        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Account Number</p>
            <input type="text" name="account_number" class="p-3 border rounded-xl" placeholder="Enter Account Number" required>
        </div>

        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Customer Name</p>
            <input type="text" name="customer_name" class="p-3 border rounded-xl" placeholder="Enter Customer Name" required>
        </div>

        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Provider</p>
            <input type="text" name="provider" class="p-3 border rounded-xl" placeholder="e.g. USA Electricity" required>
        </div>

    @elseif(in_array($bill->name, ['Airfare', 'Bus Ticket', 'Trains Tickets']))
        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Passenger Name</p>
            <input type="text" name="customer_name" class="p-3 border rounded-xl" placeholder="Full Name" required>
        </div>

        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Booking Reference</p>
            <input type="text" name="account_number" class="p-3 border rounded-xl" placeholder="Booking Ref No." required>
        </div>

    @elseif($bill->name == 'Hotel Booking')
        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Guest Name</p>
            <input type="text" name="customer_name" class="p-3 border rounded-xl" placeholder="Guest Full Name" required>
        </div>

        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Reservation ID</p>
            <input type="text" name="account_number" class="p-3 border rounded-xl" placeholder="Reservation ID" required>
        </div>

    @elseif(in_array($bill->name, ['Food Order', 'Movie Ticket']))
        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Customer Name</p>
            <input type="text" name="customer_name" class="p-3 border rounded-xl" placeholder="Enter Name" required>
        </div>

        <div class="flex flex-col justify-start mt-4">
            <p class="text-sm font-semibold pb-2 dark:text-white">Order Number</p>
            <input type="text" name="account_number" class="p-3 border rounded-xl" placeholder="Order Number" required>
        </div>
    @endif

    {{-- Hidden Fields --}}
    <input type="hidden" name="payment_source" id="selected_currency_symbol" value="{{ $userWalletsInUSD[0]['symbol'] }}">
    <input type="hidden" name="currency_name" id="selected_currency_name" value="{{ $userWalletsInUSD[0]['name'] }}">
    <input type="hidden" name="bill_id" value="{{ $bill->id }}">

    {{-- Buttons --}}
    <div class="flex justify-between items-center gap-4 pt-5">
      <button type="button" class="flex-1 py-3 bg-bgColor text-g300 rounded-xl contactSavedConfirmationModalCloseButton">Cancel</button>
      <button type="submit" class="flex-1 py-3 bg-g300 text-white rounded-xl">Pay</button>
    </div>

  </div>
</div>
</div>
</form>
@endforeach

@endsection
@section('scripts')
<script>
    $(document).ready(function(){
        // Open Modal
        $('.openPayModal').on('click', function() {
            let targetModal = $(this).data('target');
            $(targetModal).fadeIn();
        });

        // Close Modal
        $('.contactSavedConfirmationModalCloseButton, .modalBg').on('click', function() {
            $(this).closest('.contactSavedConfirmationModal').fadeOut();
        });

        // Dropdown Logic
        $('.selectCountry').on('click', function() {
            $(this).siblings('.selectCountryModal').toggleClass('invisible opacity-0 scale-75');
        });

        $('.selectCountryModal .item').on('click', function() {
            let name = $(this).data('name');
            let logo = $(this).data('logo');

            $(this).closest('.relative').find('.selectedItem').text(name);
            $(this).closest('.relative').find('#selected_wallet_logo').attr('src', logo);
            $(this).parent().parent().addClass('invisible opacity-0 scale-75');
        });

        // ✅ AJAX Submission for ALL Forms
        $('.billPaymentForm').on('submit', function(e) {
            e.preventDefault();
            let form = $(this);
            let submitBtn = form.find('button[type="submit"]');
            submitBtn.prop('disabled', true).text('Processing...');

            $.ajax({
                url: form.attr('action'),
                method: 'POST',
                data: form.serialize(),
                success: function(response) {
                    if(response.success) {
                        toastr.success(response.message);   // Show toast success
                        form.closest('.contactSavedConfirmationModal').fadeOut();
                        setTimeout(function(){
                            window.location.href = response.redirect;
                        }, 1500);
                    } else {
                        toastr.error(response.message || 'Something went wrong.');
                    }
                },
                error: function(xhr) {
                    let errorMsg = xhr.responseJSON?.message || 'An unexpected error occurred.';
                    toastr.error(errorMsg);
                },
                complete: function() {
                    submitBtn.prop('disabled', false).text('Pay');
                }
            });
        });
    });
</script>
@endsection
