@extends('layouts.muladash')
@section('title', $title)
@section('content')


    <x-danger-alert />
    <x-success-alert />

    <main
      class="container  text-n900 dark:bg-darkG300 dark:text-white pt-8 min-h-dvh"
    >
      <div class="px-6 flex justify-between items-center">
        <a href="javascript:history.back()"
        class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
      >
          <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
          <p class="text-2xl font-semibold ">Notifications</p>
        </div>
      </div>
      <div class="bg-white py-7 px-6 rounded-t-3xl dark:bg-n0">
       
        <div class="pt-6 flex flex-col gap-8">
          <div class="">
            <p class="text-sm font-semibold text-n500 dark:text-darkN500">
              Today, April 20-2025
            </p>
            <div class="pt-5 flex flex-col gap-4">

                @if ($userinfo->account_verify != 'Verified')
                    
              <div
                class="flex justify-between items-start p-4 border border-n40 rounded-3xl gap-8 dark:border-darkN40"
              >
                <div class="flex justify-start items-start gap-4">
                  <div
                    class="flex justify-center items-center text-g300 bg-bgColor dark:bg-darkG300 dark:border-darkN40 p-3.5 rounded-full text-2xl !leading-none border border-n40"
                  >
                    <i class="ph ph-info"></i>
                  </div>
                  <div class="">
                    <p class="font-semibold">Account Not Verified!</p>
                    <p class="text-sm text-n500 dark:text-darkN500 pt-2">
                      Kindly submit your details to get verified and receive payments.
                    </p>
                  </div>
                </div>
                <a class="text-xs text-nowrap" href="{{ route('kycform') }}">Verify Now</p>
              </div>
              @else

              <div
                class="flex justify-between items-start p-4 border border-n40 rounded-3xl gap-8 dark:border-darkN40"
              >
                <div class="flex justify-start items-start gap-4">
                  <div
                    class="flex justify-center items-center text-g300 bg-bgColor dark:bg-darkG300 dark:border-darkN40 p-3.5 rounded-full text-2xl !leading-none border border-n40"
                  >
                    <i class="ph ph-info"></i>
                  </div>
                  <div class="">
                    <p class="font-semibold">Account Verified!</p>
                    <p class="text-sm text-n500 dark:text-darkN500 pt-2">
                     Your Information has been Verified. Enjoy all the benefits at {{ $settings->site_name }}
                    </p>
                  </div>
                </div>
                
              </div>

              @endif
            
            </div>
          </div>
         
        </div>
      </div>
    </main>

   

@endsection
