@extends('layouts.muladash')
@section('title', $title)
@section('content')

@include('layouts.mulapart')

<x-danger-alert />
<x-success-alert />

<main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
    <div class="px-6 flex justify-between items-center">
        <a href="javascript:history.back()"
           class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl text-white">
            <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">Edit Contact</p>
        </div>
    </div>

    <form method="POST" action="{{ route('contacts.update', $contact->id) }}" id="contact-form">
        @csrf
        @method('PUT')

        <div class="px-6 pt-8 flex flex-col gap-4">
            {{-- Contact Name --}}
            <div>
                <p class="text-sm font-semibold pb-2 dark:text-white">Contact Name</p>
                <div class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                    <input name="name" type="text" required
                        value="{{ $contact->name }}"
                        placeholder="Enter Contact Name"
                        class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" />
                </div>
            </div>

            {{-- Country Selector --}}
            <div class="relative">
                <div class="p-3 flex justify-between items-center gap-2 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl cursor-pointer selectCountry">
                    <div class="flex justify-start items-center gap-1">
                        <p id="selected-country" class="text-n90 text-sm dark:text-white">
                            {{ $contact->country }} ({{ $contact->currency }})
                        </p>
                    </div>
                    <i class="ph ph-caret-down text-n90 text-lg"></i>
                </div>
                @include('partials.country')
                <input type="hidden" name="country" id="country-input" value="{{ $contact->country }}" />
                <input type="hidden" name="currency" id="currency-input" value="{{ $contact->currency }}" />
            </div>

            {{-- Contact Type --}}
            <div class="flex flex-col justify-start">
                <p class="text-sm font-semibold pb-2 dark:text-white">Contact Type</p>
                <div class="relative">
                    <div class="p-3 flex justify-between items-center gap-2 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl cursor-pointer selectContactType">
                        <div class="flex items-center gap-1">
                            <div class="size-7 flex justify-center items-center rounded-full bg-white dark:bg-darkG300">
                                <img id="selected-contact-img" src="{{ asset('muladash/assets/images/'.$contact->type.'.png') }}" alt="{{ ucfirst($contact->type) }}" />
                            </div>
                            <p id="selected-contact-type" class="text-n90 text-sm dark:text-white">
                                {{ ucfirst($contact->type) }}
                            </p>
                        </div>
                        <i class="ph ph-caret-down text-n90 text-lg"></i>
                    </div>

                    <div class="bg-white p-4 rounded-xl border border-n40 dark:border-darkN40 dark:bg-darkG300 w-full absolute right-0 top-14 max-h-[150px] overflow-y-auto selectContactModal invisible opacity-0 scale-75 duration-500">
                        <ul class="flex flex-col gap-2">
                            @foreach(['bank', 'crypto', 'paypal', 'zelle', 'cashapp'] as $type)
                                <li data-type="{{ $type }}"
                                    data-img="{{ asset('muladash/assets/images/'.$type.'.png') }}"
                                    class="contact-type-item text-xs text-n500 dark:text-darkN500 pb-2 border-b border-dashed border-n40 cursor-pointer capitalize">
                                    {{ ucfirst($type) }}
                                </li>
                            @endforeach
                        </ul>
                    </div>
                </div>
                <input type="hidden" name="type" id="contact-type-input" value="{{ $contact->type }}" />
            </div>

            {{-- Bank Fields --}}
            <div id="bank-fields" class="{{ $contact->type == 'bank' ? '' : 'hidden' }} flex flex-col gap-4">
                <input name="bank_name" type="text" placeholder="Bank Name" value="{{ $contact->bank_name }}"
                    class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl text-sm dark:text-white" />

                <input name="bank_account_number" type="text" placeholder="Account Number" value="{{ $contact->bank_account_number }}"
                    class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl text-sm dark:text-white" />

                <input name="routing_number" type="text" placeholder="Routing Number" value="{{ $contact->routing_number }}"
                    class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl text-sm dark:text-white" />

                <select name="account_type"
                    class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl text-sm dark:text-white">
                    <option value="checking" {{ $contact->account_type == 'checking' ? 'selected' : '' }}>Checking</option>
                    <option value="savings" {{ $contact->account_type == 'savings' ? 'selected' : '' }}>Savings</option>
                </select>
            </div>

            {{-- Wallet/Email --}}
            <div id="wallet-field" class="{{ $contact->type != 'bank' ? '' : 'hidden' }}">
                <input name="wallet_address" type="text" placeholder="Enter Wallet Address / Email / ID"
                       value="{{ $contact->wallet_address }}"
                       class="p-4 bg-white border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl w-full text-sm dark:text-white" />
            </div>
        </div>

        <div class="my-3 flex px-6 pt-8">
            <button type="submit" class="flex-1 py-3 bg-g300 text-white rounded-xl">
                Update Contact
            </button>
        </div>
    </form>
</main>
@endsection

@section('scripts')
<script>
$(document).ready(function() {
    $('.selectContactType').on('click', function(){
        $('.selectContactModal').toggleClass('invisible opacity-0 scale-75');
    });

    $('.contact-type-item').on('click', function(){
        let type = $(this).data('type');
        let img = $(this).data('img');

        $('#selected-contact-type').text($(this).text());
        $('#selected-contact-img').attr('src', img);
        $('#contact-type-input').val(type);

        $('#bank-fields').toggle(type === 'bank');
        $('#wallet-field').toggle(type !== 'bank');

        $('.selectContactModal').addClass('invisible opacity-0 scale-75');
    });

    $('#contact-form').submit(function(e){
        e.preventDefault();
        let $btn = $(this).find('button[type=submit]');
        $btn.prop('disabled', true).text('Updating...');

        $.ajax({
            url: $(this).attr('action'),
            method: 'POST',
            data: $(this).serialize(),
            headers: {'Accept': 'application/json'},
            success: function(){
                toastr.success('Contact updated successfully.');
                setTimeout(() => location.href = '{{ route("contacts") }}', 1200);
            },
            error: function(xhr){
                toastr.error(xhr.responseJSON.message || 'Failed to update contact.');
                $btn.prop('disabled', false).text('Update Contact');
            }
        });
    });

    $('.selectCountry').on('click', function(e){
        e.stopPropagation();
        $('.selectCountryModal').toggleClass('invisible opacity-0 scale-75');
    });

    $(document).on('click', '.country-item', function() {
        let countryName  = $(this).data('country');
        let currencyCode = $(this).data('type');

        $('#selected-country').text(countryName + ' (' + currencyCode + ')');
        $('#country-input').val(countryName);
        $('#currency-input').val(currencyCode);

        $('.selectCountryModal').addClass('invisible opacity-0 scale-75');
    });

    $(document).click(function(e) {
        if(!$(e.target).closest('.selectContactType, .selectContactModal').length) {
            $('.selectContactModal').addClass('invisible opacity-0 scale-75');
        }
    });
});
</script>
@endsection
