@extends('layouts.muladash')
@section('title', $title)
@section('content')
    <!-- Title -->

  <body class="">
    @if ($t->type == 'Deposit')
    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
      <div class="px-6 flex justify-between items-center">
        <a
          href="javascript:history.back()"
          class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
        >
          <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
          <p class="text-2xl font-semibold">Deposit Details</p>
        </div>
      </div>
      <div class="pt-8 flex justify-center items-center flex-col">
        <div class="rounded-full overflow-hidden bg-g300">
          <img
            src="{{ asset('storage/' . $t->wallet->currency->logo) }}" alt="{{ $t->wallet->currency->name }}"
            alt=""
            class="w-[140px] h-[140px] object-cover"
          />
        </div>
        <p class="text-[52px] font-bold flex justify-start pt-2">
            {{ number_format($amountInUsd, 2, '.', ',') }} <span class="text-xl text-g300 pt-2">$</span>
        </p>
        <p class="text-sm font-semibold pt-3">You topped up your {{ $settings->site_name }} {{ $t->wallet->currency->name }} Account</p>
      </div>

      <div class="pt-8">
        <div
          class="border border-n40 dark:border-darkN40 flex flex-col gap-5 p-4 mx-6 rounded-2xl"
        >
          <div
            class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
          >
            <p class="text-sm text-n500 dark:text-darkN500">Amount (NGN)</p>
            <p class="text-sm font-medium text-g300">NGN{{ number_format($t->amount_ngn, 2, '.', ',') }} </p>
          </div>

          <div
            class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
          >
            <p class="text-sm text-n500 dark:text-darkN500">Transaction Hash</p>
            <p class="text-sm">{{ Str::substr($t->hash ?? 'N/A', 0, 9) . '.......' . Str::substr($t->hash ?? 'N/A', -9) }}</p>
          </div>
          <div
            class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
          >
            <p class="text-sm text-n500 dark:text-darkN500">From</p>
            <p class="text-sm">{{ Str::substr($t->from_address ?? 'N/A', 0, 12) . '.......' . Str::substr($t->from_address ?? 'N/A', -12) }}</p>
          </div>

          <div
            class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
          >
            <p class="text-sm text-n500 dark:text-darkN500">Date</p>
            <p class="text-sm">{{ \Carbon\Carbon::parse($t->created_at)->toDayDateTimeString() }}</p>
          </div>
          
        </div>
      </div>
      <div class="pt-4 px-6">
        <div
          class="bg-bgColor border border-bgColor2 rounded-2xl p-4 dark:bg-darkN20 dark:border-darkN40"
        >
          
          <p class="text-n500 dark:text-darkN500 text-sm pt-4">
           your Naira equivalent has been confirmed on the blockchain and paid to your Account
          </p>
        </div>
      </div>
      <div class="flex px-6 py-8">
        @if ($t->payment_mode = 'BTC')
        <a
          href="https://www.blockchain.com/explorer/transactions/btc/{{$t->hash}}" target="_blank"
          class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
          >Explore TXID</a
        >
        @elseif ($t->payment_mode = 'ETH')
        <a
          href="https://etherscan.io/tx/{{$t->hash}}"  target="_blank"
          class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
          >Explore TXID</a
        >
        @elseif ($t->payment_mode = 'USDT.TRC20')
        <a
          href="https://tronscan.org/#/transaction/{{$t->hash}}"  target="_blank"
          class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
          >Explore TXID</a
        >
        @else
        <a
          href="https://etherscan.io/tx/{{$t->hash}}"  target="_blank"
          class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
          >Explore TXID</a
        >
        @endif

      </div>
     
    </main>


    @else
    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
        <div class="px-6 flex justify-between items-center">
          <a
            href="javascript:history.back()"
            class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
          >
            <i class="ph ph-caret-left"></i>
          </a>
          <div class="flex-1 flex justify-center items-center pr-12">
            <p class="text-2xl font-semibold">Withdrawal Details</p>
          </div>
        </div>
        <div class="pt-8 flex justify-center items-center flex-col">
          <div class="rounded-full overflow-hidden bg-g300">
            <img
              src="{{ asset('storage/' . $t->wallet->currency->logo) }}" alt="{{ $t->wallet->currency->name }}"
              alt=""
              class="w-[140px] h-[140px] object-cover"
            />
          </div>
          <p class="text-[52px] font-bold flex justify-start pt-2">
            {{ number_format($amountInUsd, 2, '.', ',') }} <span class="text-xl text-g300 pt-2">$</span>
          </p>
          <p class="text-sm font-semibold pt-3">You got paid to your Bank Account</p>
        </div>
  
        <div class="pt-8">
            <div
              class="border border-n40 dark:border-darkN40 flex flex-col gap-5 p-4 mx-6 rounded-2xl"
            >
              <div
                class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
              >
                <p class="text-sm text-n500 dark:text-darkN500">Amount (NGN)</p>
                <p class="text-sm font-medium text-g300">NGN{{ number_format($t->amount_ngn, 2, '.', ',') }} </p>
              </div>
    
              <div
                class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
              >
                <p class="text-sm text-n500 dark:text-darkN500">Transaction ID</p>
                <p class="text-sm">{{ $t->txn_id }}</p>
              </div>
              <div
                class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
              >
                <p class="text-sm text-n500 dark:text-darkN500">To</p>
                <p class="text-sm">{{ $t->withdrawal_to }}</p>
              </div>
    
              <div
                class="flex justify-between items-center pb-5 border-b border-dashed border-n40 dark:border-darkN40"
              >
                <p class="text-sm text-n500 dark:text-darkN500">Date</p>
                <p class="text-sm">{{ \Carbon\Carbon::parse($t->created_at)->toDayDateTimeString() }}</p>
              </div>
              
            </div>
          </div>
        <div class="pt-4 px-6">
          <div
            class="bg-bgColor border border-bgColor2 rounded-2xl p-4 dark:bg-darkN20 dark:border-darkN40"
          >
           
            <p class="text-n500 dark:text-darkN500 text-sm pt-4">
             If you did not receive your payment, kindly click the button to contact support
            </p>
          </div>
        </div>
        <div class="flex px-6 py-8">
          <a
            href="{{ route('support') }}"
            class="flex-1 py-3 bg-g300 text-white text-center rounded-xl font-medium border border-g300"
            >Contact support</a
          >
        </div>
      </main>
    @endif





    
@endsection
