@extends('layouts.muladash')
@section('title', $title)
@section('content')
    <!-- Title -->

    @include('layouts.mulapart')
    
<style>

.logo-switch.dark {
    display: none;
}

/* When body has .dark class */
body.dark .logo-switch {
    display: none;
}

body.dark .logo-switch.dark {
    display: inline;
}

</style>
<!-- Splash Screen Start -->
<div class="preloader inset-0 z-50">
    <div
      class="h-full bg-bgColor flex flex-col justify-center items-center text-center container"
    >
      <div class="zoomInOut">
        <div class="">
          <img src="/muladash/assets/images/preloader.png" alt="" />
        </div>
        
      </div>
    </div>
  </div>
  <!-- Splash Screen End -->
  <main
    class="container bg-bgColor dark:bg-darkG300 text-n900 dark:text-white pt-8 min-h-dvh flex flex-col"
  >
    <div class="px-6 flex justify-between items-start">
      <div class="rounded-full w-12 h-12 overflow-hidden bg-bgColor2">
        <img src="/muladash/assets/images/user.png" alt="" />
      </div>
 
      <!-- Light Mode Logo -->
<img src="{{ asset('storage/' . $settings->logo) }}" class="logo-switch" alt="Logo">

<!-- Dark Mode Logo -->
<img src="{{ asset('storage/' . $settings->logo_white) }}" class="logo-switch dark" alt="Dark Logo">


      <a
        href="{{ route('notifications') }}"
        class="text-2xl text-g300 border border-n500 !leading-none flex justify-center items-center rounded-full p-2 relative bg-white dark:bg-n0"
      >
        <div
          class="absolute top-0 right-0 bg-bgColor rounded-full w-3 h-3 flex justify-center items-center dark:bg-n0"
        >
          <div class="w-2 h-2 rounded-full bg-red-500"></div>
        </div>
        <i class="ph-fill ph-bell-simple"></i>
      </a>
    </div>
    <div class="text-center flex justify-between items-center flex-col py-8">
      <p class="text-[52px] font-bold flex justify-start -mt-3">
       {{ number_format($totalBalanceInUSD, 2) }} <span class="text-xl text-g300 pt-2.5">{{ $settings->currency }}</span>
      </p>
      <p class="text-n500 dark:text-darkN500">Total Balance</p>
    </div>
    <div class="px-6 relative z-20">
      <div class="flex gap-3 justify-start items-center">
        <a
          href="{{ route('deposits') }}"
          class="bg-orange-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div
            class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center"
          >
          <i class="ph-fill ph-wallet text-white"></i>
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Topup
          </p>
        </a>
        <a
          href="{{ route('send') }}"
          class="bg-red-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div
            class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center"
          >
            <img src="/muladash/assets/images/icon2.png" class="size-4" alt="" />
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Send
          </p>
        </a>
        <a
          href="{{ route('paybills') }}"
          class="bg-yellow-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div
            class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center"
          >
            <img src="/muladash/assets/images/icon3.png" class="size-4" alt="" />
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Pay
          </p>
        </a>
        @if (Auth::user()->account_verify == 'Verified')
        {{-- Show Withdraw if user is Verified --}}
        <a
          href="{{ route('withdraw') }}"
          class="bg-sky-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center">
            <i class="ph-fill ph-hand-withdraw text-white"></i>
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            Withdraw
          </p>
        </a>
    @else
        {{-- Show KYC if user is NOT Verified --}}
        <a href="{{ route('kycform') }}"
          class="bg-sky-200 rounded-2xl p-4 flex-1 max-w-[85px] flex flex-col justify-center items-center shrink-0"
        >
          <div class="h-7 w-7 rounded-full bg-n0 flex justify-center items-center">
            <img src="/muladash/assets/images/icon2.png" class="size-4" alt="" />
          </div>
          <p class="pt-3 text-center dark:text-n0 font-medium text-sm">
            KYC
          </p>
        </a>
    @endif
    
      </div>
    </div>
    <div class="bg-white rounded-t-3xl pt-14 -mt-14 flex-1 pb-32 dark:bg-n0">
      <div class="px-6 pt-8">
        <a
          href="{{ route('cards') }}"
          class="bg-g300 rounded-2xl py-5 px-6 flex justify-between items-center"
        >
          <div class="w-1/2">
            <p class="text-white text-xl font-semibold">
            Get a Prepaid Debit Card
            </p>
            <p class="text-white text-xs pt-1.5">
               in less than 5 Minutes
            </p>
            <i class="ph ph-arrow-right text-white"></i>
          </div>
          <div class="">
            <img src="/muladash/assets/images/pay-bill-illus.png" alt="" />
          </div>
        </a>
      </div>
      
      <x-danger-alert />
      <x-success-alert />
  

      <div class="px-6 pt-8">
        <div class="flex justify-between items-center">
          <p class="text-xl font-semibold">Recent Transactions</p>
          <a
            href="{{ route('transactions') }}"
            class="text-g300 font-semibold text-sm"
          >
            View All</a
          >
        </div>
        <div class="flex flex-col gap-4 pt-6">
         
        

      
          @php
          use Illuminate\Support\Str;
        @endphp
        
        @foreach ($recentTransactions as $tx)
        
          <a href="{{ route('status', ['id' => $tx->id]) }}"
             class="flex justify-between items-center border-b border-dashed border-n40 dark:border-darkN40 pb-4">
        
            <div class="flex justify-start items-center gap-4">
              {{-- currency logo --}}
              <div class="rounded-full bg-bgColor2 dark:bg-darkN40 overflow-hidden">
                @if ($tx->currency)
                    <img src="{{ asset('storage/' . $tx->currency->logo) }}"
                         alt="{{ $tx->currency->name }} logo"
                         class="w-[60px] h-[60px] object-cover" />
                @else
                    <img src="{{ asset('storage/cards/visa.png') }}"
                         alt="Credit Card"
                         class="w-[60px] h-[60px] object-cover" />
                @endif
            </div>
            
        
              {{-- deposit vs withdrawal info --}}
              
                <div>
                  <p class="font-semibold">{{ $tx->type }}</p>
                  <p class="text-n500 dark:text-darkN500 text-xs pt-2.5">
                    From: 
                    {{ $tx->from }}
                    <br/>
                    {{ $tx->created_at->toDayDateTimeString() }}
                  </p>
                </div>
            </div>
        
            {{-- amount and status --}}
            <div class="flex flex-col justify-end items-end">
              @if (Str::contains($tx->type, 'Deposit'))
                <p class="font-semibold pb-2">+
                  {{ $settings->currency }} {{ number_format($tx->amount, 2, '.', ',') }}
                </p>
              @else
                <p class="font-semibold pb-2">–
                  {{ $settings->currency }} {{ number_format($tx->amount, 2, '.', ',') }}
                </p>
              @endif
                
              @if (Str::contains($tx->status, 'Pending'))
              <p class="text-orange text-xs py-0.5 px-2 bg-orange-200 rounded-md dark:bg-darkN40">
                {{ ucfirst($tx->status) }}
              </p>
              @else
              <p class="text-white text-xs py-0.5 px-2 bg-g300 rounded-md dark:bg-darkN40">
                {{ ucfirst($tx->status) }}
              </p>
              @endif
            </div>
          </a>
        @endforeach
        


        
       
          
        </div>
      </div>
    </div>
        
  </main>
@endsection
