@extends('layouts.muladash')
@section('title', $title)
@section('content')

<x-danger-alert />
<x-success-alert />

<main class="container bg-g300 text-n900 dark:bg-darkG300 dark:text-white pt-8 min-h-dvh flex flex-col overflow-hidden">
    <div class="px-6 flex justify-between items-center pb-24">
        <a href="javascript:history.back()"
           class="flex justify-center items-center bg-white dark:text-n0 w-12 h-12 rounded-full text-2xl">
            <i class="ph ph-caret-left"></i>
        </a>
    </div>

    <div class="bg-white py-7 px-6 rounded-t-3xl flex flex-col gap-4 relative flex-1 dark:bg-n0">
        <div class="flex justify-center items-center -mt-24 flex-col text-center pb-8 border-b border-dashed border-n40 dark:border-darkN40">
            <div class="bg-g300 p-1.5 rounded-full">
                <img src="{{ asset('muladash/assets/images/contact-user.png') }}" alt="Contact" />
            </div>
            <div class="pt-6">
                <p class="text-2xl font-semibold">{{ $contact->name }}</p>
                <p class="pt-1 text-n500 dark:text-darkN500 text-sm">
                    {{ ucfirst($contact->type) }} | {{ $contact->country }} ({{ $contact->currency }})
                </p>
            </div>
        </div>

        {{-- Contact Details --}}
        <div class="flex flex-col gap-4 pt-8">
            @if($contact->type == 'bank')
                <div class="p-4 rounded-2xl border border-n40 dark:border-darkN40">
                    <p class="font-semibold">Bank Name</p>
                    <p class="pt-1 text-n500 dark:text-darkN500 text-sm">{{ $contact->bank_name }}</p>
                </div>
                <div class="p-4 rounded-2xl border border-n40 dark:border-darkN40">
                    <p class="font-semibold">Account Number</p>
                    <p class="pt-1 text-n500 dark:text-darkN500 text-sm">{{ $contact->bank_account_number }}</p>
                </div>
            @else
                <div class="p-4 rounded-2xl border border-n40 dark:border-darkN40">
                    <p class="font-semibold">{{ ucfirst($contact->type) }} Address</p>
                    <p class="pt-1 text-n500 dark:text-darkN500 text-sm">{{ $contact->wallet_address }}</p>
                </div>
            @endif
        </div>

        {{-- Action Buttons --}}
        <div class="pt-12 flex justify-center items-center gap-5">
            <div class="flex flex-col gap-1 text-center items-center cursor-pointer">
                <a href="{{ route('editcontacts', $contact->id) }}">
                    <div class="flex justify-center items-center p-1.5 rounded-md bg-bgColor text-g300 dark:bg-darkN40 text-2xl">
                        <i class="ph ph-pencil"></i>
                    </div>
                    <p class="text-sm font-medium">Edit Contact</p>
                </a>
            </div>
            <div class="flex flex-col gap-1 text-center items-center cursor-pointer">
                <a href="{{ route('sendtocontact', $contact->id) }}">
                    <div class="flex justify-center items-center p-1.5 rounded-md bg-bgColor text-g300 dark:bg-darkN40 text-2xl">
                        <i class="ph ph-money"></i>
                    </div>
                    <p class="text-sm font-medium">Send Money</p>
                </a>
            </div>
            <div class="flex flex-col gap-1 text-center items-center cursor-pointer deleteContactModalOpenButton">
                <div class="flex justify-center items-center p-1.5 rounded-md bg-red-100 dark:bg-darkN40 text-red-500 text-2xl">
                    <i class="ph-fill ph-trash"></i>
                </div>
                <p class="text-sm font-medium">Delete Contact</p>
            </div>
        </div>
    </div>
</main>

{{-- Delete Modal --}}
<div class="deleteContactModal bottom-modal container fixed inset-0 z-50 hidden">
    <div class="modalBg absolute inset-0 w-full bg-black opacity-30 dark:bg-white"></div>
    <div class="modal relative z-10 flex h-full flex-col items-end justify-end text-center dark:text-white">
        <div class="absolute bottom-0 left-0 right-0">
            <img src="{{ asset('muladash/assets/images/rounded-modal-white-bg.png') }}" class="block dark:hidden" />
            <img src="{{ asset('muladash/assets/images/rounded-modal-black-bg.png') }}" class="hidden dark:block" />
        </div>
        <div class="relative w-full overflow-y-auto">
            <div class="px-6 pt-8">
                <p class="text-2xl font-bold border-b border-dashed border-n40 dark:border-darkN40 pb-5">Delete Contact</p>
                <p class="text-n500 dark:text-darkN500 pt-4">Do you want to delete this contact?</p>
            </div>
            <div class="px-6 py-8 flex justify-between items-center gap-4">
                <button class="flex-1 py-3 bg-bgColor text-g300 rounded-xl deleteContactModalCloseButton">Cancel</button>
                <button class="flex-1 py-3 bg-red-500 text-white rounded-xl confirmDeleteContact" data-id="{{ $contact->id }}">Yes, Delete</button>
            </div>
        </div>
    </div>
</div>

@endsection

@section('scripts')
<script>
$(document).ready(function() {
    // Open modal
    $('.deleteContactModalOpenButton').click(function() {
        $('.deleteContactModal').removeClass('hidden');
    });

    // Close modal
    $('.deleteContactModalCloseButton, .modalBg').click(function() {
        $('.deleteContactModal').addClass('hidden');
    });

    // Confirm Delete via AJAX
    $('.confirmDeleteContact').click(function() {
        let contactId = $(this).data('id');

        $.ajax({
            url: '/contacts/' + contactId,
            method: 'DELETE',
            headers: {
                'X-CSRF-TOKEN': '{{ csrf_token() }}',
                'Accept': 'application/json'
            },
            success: function(response) {
                toastr.success(response.message);
                setTimeout(() => window.location.href = '{{ route("contacts") }}', 1000);
            },
            error: function() {
                toastr.error('Failed to delete contact.');
            }
        });
    });
});
</script>
@endsection
