@extends('layouts.muladash')
@section('title', $title)
@section('content')
    <!-- Title -->
    

    @include('layouts.dasht')

    <div class="header-style2 fixed-top bg-menuDark">
        <div class="d-flex justify-content-between align-items-center">
            <a class="box-account" href="{{ route('profile') }}">
                <img src="/newdash/images/avt/avt2.jpg" alt="img" class="avt">
                <div class="info">
                    <p class="text-xsmall text-secondary">Welcome back!</p>
                    <h5 class="mt-4">{{ Auth::user()->username }}</h5>

                </div>
            </a>
            <div class="d-flex align-items-center gap-8">
                <a href="choose-cryptocurrency.html" class="icon-search"></a>
                <a href="#notification" class="icon-noti box-noti" data-bs-toggle="modal"></a>
            </div>
        </div>
    </div>
    <div class="pt-68 pb-80">
        <div class="bg-menuDark tf-container">
            <div class="pt-12 pb-12 mt-4">
                <h5><span class="text-primary">WalletID</span> - <a href="#" class="choose-account" data-bs-toggle="modal" data-bs-target="#accountWallet"><span class="dom-text">{{ Auth::user()->walletid }} </span> &nbsp;</a> </h5>
                <h1 class="mt-16"><a href="#">{{ $settings->currency }}{{ number_format($balanceInUSD, 2) }}</a></h1>
                <ul class="mt-16 grid-4 m--16">
                    <li>
                        <a href="{{ route('withdrawamount', ['currency_symbol' => $wallet->currency->symbol]) }}" class="tf-list-item d-flex flex-column gap-8 align-items-center">
                            <span class="box-round bg-surface d-flex justify-content-center align-items-center"><i class="icon icon-way"></i></span>
                            Send
                        </a>
                    </li>
                    <li>
                        <a href="{{ route('newdeposit', ['currency_symbol' => $wallet->currency->symbol]) }}" class="tf-list-item d-flex flex-column gap-8 align-items-center">
                            <span class="box-round bg-surface d-flex justify-content-center align-items-center"><i class="icon icon-way2"></i></span>
                            Receive
                        </a>
                    </li>
                    <li>
                        <a href="#" class="tf-list-item d-flex flex-column gap-8 align-items-center">
                            <span class="box-round bg-surface d-flex justify-content-center align-items-center"><i class="icon icon-wallet"></i></span>
                            Buy
                        </a>
                    </li>
                    <li data-bs-toggle="modal" data-bs-target="#walletHistory">
                        <a href="javascript:void(0);" class="tf-list-item d-flex flex-column gap-8 align-items-center">
                            <span class="box-round bg-surface d-flex justify-content-center align-items-center"><i class="icon icon-history"></i></span>
                            Connect
                        </a>
                    </li>
                </ul>
            </div>
        </div>
        
        <div class="bg-menuDark tf-container">
            <div class="tf-tab pt-12 mt-4">
                <div class="tab-slide">
                    <ul class="nav nav-tabs wallet-tabs" role="tablist" >
                        <li class="item-slide-effect"></li>
                        <li class="nav-item active" role="presentation">   
                            <button class="nav-link active"  data-bs-toggle="tab" data-bs-target="#history">Send History</button>
                        </li>
                        <li class="nav-item" role="presentation">
							<button class="nav-link" data-bs-toggle="tab" data-bs-target="#market">Recieve History</button>
						</li>
                        
                        
                    </ul>
                </div>
                <div class="tab-content pt-16 pb-16">
					<div class="tab-pane fade active show" id="history" role="tabpanel">
						<ul>
                           
                            @forelse ($withdrawals as $withdrawal)
    <li class="mt-8">
        <a href="{{ route('details', ['symbol' => $wallet['currency']['symbol'], 'id' => $withdrawal->id]) }}" class="coin-item style-1 gap-12 bg-surface">
            <img src="{{ asset('storage/app/public/' . $wallet->currency->logo) }}" alt="img" class="img">
            <div class="content">
                <div class="title">
                    <p class="mb-4 text-large">
                        Send 
                       
                        <i class="text-small">{{ $withdrawal->status }}</i>
                       
                    </p>
                    <span class="text-secondary">To: {{ Str::substr($withdrawal->paydetails, 0, 7) . '.......' . Str::substr($withdrawal->paydetails, -7) }}
                    </span> <br/>
                    <span class="text-secondary">{{ \Carbon\Carbon::parse($withdrawal->created_at)->toDayDateTimeString() }}</span>
                </div>
                <p class="text-small">
                    @if ($withdrawal->status == 'Rejected')
                        <span class="text-green">+</span> 
                        @else
                        <span class="text-red">-</span> 
                        @endif
                        {{ $settings->currency }} {{ number_format($withdrawal->amount, 2, '.', ',') }}
                </p>
            </div>
        </a>
    </li>
@empty
    <p>No withdrawals found.</p>
@endforelse

                           
                           
                        </ul>
					</div>
					<div class="tab-pane fade" id="market" role="tabpanel">
						<ul>
                           
                            @forelse ($deposits  as $deposit)
                            <li class="mt-8">
                                <a href="{{ route('details', ['symbol' => $wallet['currency']['symbol'], 'id' => $deposit->id]) }}" class="coin-item style-1 gap-12 bg-surface">
                                    <img src="{{ asset('storage/app/public/' . $wallet->currency->logo) }}" alt="img" class="img">
                                    <div class="content">
                                        <div class="title">
                                            <p class="mb-4 text-large">Receive <i class="text-small">{{$deposit->status}}</i> </p>
                                            <span class="text-secondary">From: {{ Str::substr($deposit->from_address, 0, 7) . '.......' . Str::substr($deposit->from, -7) }}
                                            </span> <br/>
                                            <span class="text-secondary">{{ \Carbon\Carbon::parse($deposit->time)->toDayDateTimeString() }}</span>
                                        </div>
                                           
                                        <p class="text-small"><span class="">+</span>{{ $settings->currency }} {{ number_format($deposit->usd_amount, 2, '.', ',') }} </p>
                                    </div>
                                </a>
                            </li>
                            @empty
                            <li class="mt-8">
                            </li>
                            @endforelse
                         
                            
                        </ul>
					</div>
				</div>
            </div>
        </div>
    </div>
    

@endsection
