@extends('layouts.muladash')
@section('title', $title)
@section('content')


  <body class="">
    <main class="container dark:bg-n0 text-n900 dark:text-white pt-8 min-h-dvh">
      <div class="px-6 flex justify-between items-center pb-8">
        <a href="javascript:history.back()"
          class="flex justify-center items-center bg-g300 w-12 h-12 rounded-full text-2xl !leading-none text-white"
        >
          <i class="ph ph-caret-left"></i>
        </a>
        <div class="flex-1 flex justify-center items-center pr-12">
          <p class="text-2xl font-semibold">About Us</p>
        </div>
      </div>
      <div
        class="pl-6 flex flex-col gap-4 text-sm text-n500 dark:text-darkN500 h-[80vh] overflow-auto pr-4"
      >
        <p>
          Welcome to {{ $settings->site_name }} – your trusted solution for seamless money
          transfers, secure digital wallet management, and hassle-free online
          payments. Designed with user-centric innovation at its core, {{ $settings->site_name }}
          offers a modern, intuitive, and reliable UI kit tailored for financial
          applications. 
          <p>Our mission is to simplify the complexities of personal
            finance and empower individuals and businesses to manage their money
            with confidence and ease.</p>
        </p>
        <p>
          {{ $settings->site_name }} is built for flexibility and efficiency, whether you're
          transferring funds to loved ones, making payments to vendors, or
          managing a digital wallet. 
          <p>With a sleek and professional design, every
            component of {{ $settings->site_name }} is crafted to enhance user experience while
            maintaining the highest standards of security. From real-time
            transactions to detailed payment history, {{ $settings->site_name }} ensures transparency
            and convenience at every step.</p>
        </p>
        <p>
          We understand the importance of trust in financial interactions, which
          is why {{ $settings->site_name }} integrates cutting-edge encryption and compliance with
          global data protection standards. 
        </p>
        <p>Our platform is designed to meet the
            needs of startups, fintech developers, and established enterprises
            seeking to launch or enhance their financial applications.</p>
        <p>
          At {{ $settings->site_name }}, innovation meets functionality. Our UI kit is fully
          customizable and adaptable to a variety of financial use cases, making
          it the perfect choice for creating professional-grade finance apps.
        <p>  Whether you're building a peer-to-peer transfer service, a business
            payment portal, or a multi-currency wallet, {{ $settings->site_name }} has everything you
            need to bring your vision to life.</p>
        </p>
      </div>
    </main>

    @endsection