<!DOCTYPE html>
<html>
<head>
    <title>Transaction Receipt</title>
    <style>
        body { font-family: DejaVu Sans, sans-serif; }
        .header { text-align: center; margin-bottom: 20px; }
        .details { margin: 0 auto; width: 80%; }
        .details p { margin: 5px 0; }
    </style>
</head>
<body>
    <div class="header">
        <h2>{{ config('app.name') }} - Transaction Receipt</h2>
    </div>
    <div class="details">
        <p><strong>Reference ID:</strong> {{ $transaction->ref }}</p>
        <p><strong>Type:</strong> {{ $transaction->type }}</p>
        <p><strong>Amount:</strong> {{ $transaction->symbol }}{{ number_format($transaction->amount, 2) }}</p>
        <p><strong>Status:</strong> {{ ucfirst($transaction->status) }}</p>
        <p><strong>Date:</strong> {{ \Carbon\Carbon::parse($transaction->transaction_time)->toDayDateTimeString() }}</p>
        <p><strong>Payment Mode:</strong> {{ $transaction->payment_mode }}</p>
        @if($transaction->bank_name)
            <p><strong>Bank:</strong> {{ $transaction->bank_name }}</p>
        @endif
        @if($transaction->crypto_address)
            <p><strong>Crypto Address:</strong> {{ $transaction->crypto_address }}</p>
        @endif
    </div>
</body>
</html>
