
<!DOCTYPE html>
<html lang="en">
  <head>
    <meta charset="UTF-8" />
    <meta name="viewport" content="width=device-width, initial-scale=1.0" />
    <title>{{ $settings->site_name }} - {{ $settings->description }}</title>
    <script src="https://unpkg.com/@phosphor-icons/web@2.1.1"></script>
  <!-- Manifest -->
  <link rel="manifest" href="{{ asset('manifest.json') }}">

  <!-- Theme color -->
  <meta name="theme-color" content="rgb(67, 126, 157)">
  
  <!-- PWA for iOS -->
  <link rel="apple-touch-icon" href="{{ asset('icons/icon-192x192.png') }}">
  <meta name="apple-mobile-web-app-capable" content="yes">
    <link
      rel="shortcut icon"
      href="{{ asset('storage/app/public/'.$settings->favicon)}}"
      type="image/x-icon"
    />
    <link rel="stylesheet" href="/muladash/assets/css/swiper.min.css" />
  <link href="/muladash/assets/css/index.css" rel="stylesheet"></head>
  <body class="">
    <!-- Splash Screen Start -->
    <div class="preloader inset-0 z-50 hidden">
      <div
        class="h-full bg-bgColor flex flex-col justify-center items-center text-center container"
      >
        <div class="zoomInOut">
          <div class="">
            <img src="/muladash/assets/images/logo.png" alt="" />
          </div>
          <p class="pt-6 text-4xl font-bold text-n900">
            {{ $settings->site_name }}<span class="text-g300">X</span>
          </p>
        </div>
      </div>
    </div>
    <!-- Splash Screen End -->

    @yield('content')

    <script>
      if ('serviceWorker' in navigator) {
          navigator.serviceWorker.register('/service-worker.js')
              .then(function() {
                  console.log("Service Worker Registered");
              });
      }
  </script>
    <!-- ======Javascript Dependencies -->
    <script src="/muladash/assets/js/main.js"></script>
    <script src="/muladash/assets/js/plugins/swiper-bundle.min.js"></script>
    <script src="/muladash/assets/js/plugins/plugin-custom.js"></script>
  <script defer src="/muladash/assets/js/index.js"></script></body>
</html>


