<style>
    .pagination {
        flex-wrap: nowrap !important;   /* Prevent wrapping */
        overflow-x: auto;               /* Allow horizontal scroll if too many pages */
    }
    .pagination li {
        white-space: nowrap;
    }
    .pagination::-webkit-scrollbar {
        height: 6px;
    }
    .pagination::-webkit-scrollbar-thumb {
        background: #ccc;
        border-radius: 3px;
    }
</style>

<div class="my-3">
    @isset($links->current_page)
        <nav aria-label="Page navigation">
            <ul class="pagination d-flex flex-wrap justify-content-start pagination-sm">
                @foreach ($links->links as $link)
                    @php
                        parse_str(parse_url($link->url)['query'] ?? '', $params);
                        $page = $params['page'] ?? 1;
                    @endphp

                    @if ($link->url == null)
                        <li class="page-item disabled">
                            <a class="page-link">{{ html_entity_decode($link->label) }}</a>
                        </li>
                    @else
                        <li class="page-item {{ $link->active ? 'active' : '' }}">
                            <a class="page-link"
                               href="{{ route('signals', ['page' => $page]) }}">{{ html_entity_decode($link->label) }}</a>
                        </li>
                    @endif
                @endforeach
            </ul>
        </nav>
    @endisset
</div>
