@extends('layouts.mulaauth')
@section('title', 'Create Account')
@section('content')

<style>
    /* Password rule styles—unchanged */
    .invalid {
        color: red;
        margin: -2px;
        font-size: 10px;
    }
    .valid {
        color: green;
        margin: -2px;
        font-size: 10px;
    }
</style>

<div class="container px-6 pb-8 pt-12 h-dvh text-n900 dark:bg-n0">
    <div class="flex justify-center items-center text-center flex-col">
        <h1 class="text-2xl font-medium dark:text-white">Create Account</h1>
        <p class="text-sm text-n500 dark:text-darkN500 pt-3 px-4">
            Create your account and unlock a world of fast crypto exchanges.
        </p>
    </div>

    <form class="flex flex-col gap-4 pt-8" id="signupForm" action="{{ route('register') }}" method="POST">
        @csrf
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Username</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="text" name="username" placeholder="Enter usernnme" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>

        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Email</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
                <input type="text" name="email" placeholder="Enter email" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
            </div>
        </div>
        <div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Password</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
                <input type="password" name="password" placeholder="Password" id="password" class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
                <i class="ph ph-eye-slash passwordShow cursor-pointer text-n90 text-lg !leading-none"></i>
            </div>
            <!-- Password Help Rules—key notice: IDs match JS -->
            <div id="password-rules" class="mb-3" style="margin: 10px 0px 0px 0px;">
                <p id="uppercase" class="invalid">At least one uppercase letter</p>
                <p id="number" class="invalid">At least one number</p>
                <p id="special" class="invalid">At least one special character</p>
                <p id="length" class="invalid">Minimum 8 characters</p>
            </div>
        </div>


		<div class="flex flex-col justify-start">
            <p class="text-sm font-semibold pb-2 dark:text-white">Verify Password</p>
            <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
                <input type="password" name="password_confirmation" placeholder="Password" id="password" class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
                <i class="ph ph-eye-slash passwordShow cursor-pointer text-n90 text-lg !leading-none"></i>
            </div>
            
        </div>
				<div class="my-3 flex">
            <button type="submit" id="dash" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">Sign Up</button>
        </div>
    </form>

    <div class="pt-4 text-center text-sm text-n500 dark:text-darkN500">
        Already have an account?
        <a href="{{ route('login') }}" class="text-g300 font-medium">Sign In</a> here
    </div>
</div>

@endsection

@section('scripts')

<script>
    $(document).ready(function() {
        if (typeof $ === 'undefined') {
            console.error('jQuery not loaded');
            return;
        }
        console.log('jQuery loaded'); // Debug—confirm load

        // Password visibility toggle—key notice: fixed and consolidated
        $('.passwordShow').on('click', function() {
            var $passwordInput = $(this).siblings('#password');
            if ($passwordInput.attr('type') === 'password') {
                $passwordInput.attr('type', 'text');
                $(this).removeClass('ph-eye-slash').addClass('ph-eye');
            } else {
                $passwordInput.attr('type', 'password');
                $(this).removeClass('ph-eye').addClass('ph-eye-slash');
            }
            console.log('Password visibility toggled'); // Debug—confirm click
        });

        // Password rules logic—unchanged
        const passwordInput = document.getElementById('password');
        const uppercaseRule = document.getElementById('uppercase');
        const numberRule = document.getElementById('number');
        const specialRule = document.getElementById('special');
        const lengthRule = document.getElementById('length');
        const uppercasePattern = /[A-Z]/;
        const numberPattern = /[0-9]/;
        const specialPattern = /[!@#$%^&*(),.?":{}|<>[\]]/;
        const lengthPattern = /.{8,}/;

        function checkPassword() {
            const password = passwordInput.value;
            console.log('Checking password:', password);
            uppercaseRule.className = uppercasePattern.test(password) ? 'valid' : 'invalid';
            numberRule.className = numberPattern.test(password) ? 'valid' : 'invalid';
            specialRule.className = specialPattern.test(password) ? 'valid' : 'invalid';
            lengthRule.className = lengthPattern.test(password) ? 'valid' : 'invalid';
        }

        if (passwordInput) {
            passwordInput.addEventListener('input', checkPassword);
            console.log('Password input event bound');
        } else {
            console.error('Password input not found');
        }

        // AJAX signup submission—unchanged
        $('#signupForm').on('submit', function(e) {
            e.preventDefault();
            console.log('Signup form intercepted');
            var $button = $('#dash');
            $button.text('Processing...');
            $button.prop('disabled', true);

            $.ajax({
                url: $(this).attr('action'),
                method: 'POST',
                data: $(this).serialize(),
                dataType: 'json',
                success: function(response) {
                    console.log('Success Response:', response);
                    if (response.success) {
                        toastr.success(response.message || 'Signup successful!', "Success", {
                            timeOut: 3000,
                            progressBar: true
                        });
                        setTimeout(function() {
                            window.location.href = response.redirect;
                        }, 3000);
                    } else {
                        toastr.error(response.message || 'Signup failed.', "Signup Failed", {
                            timeOut: 3000,
                            progressBar: true
                        });
                        $button.text('Sign Up');
                        $button.prop('disabled', false);
                    }
                },
                error: function(xhr) {
                    console.log('Error Response:', xhr.responseJSON);
                    var message = xhr.responseJSON?.message || 'Something went wrong.';
                    toastr.error(message, "Error", {
                        timeOut: 3000,
                        progressBar: true
                    });
                    $button.text('Sign Up');
                    $button.prop('disabled', false);
                }
            });
        });
    });
</script>
@endsection