@extends('layouts.mulaauth')
@section('title', 'Login account')
@section('content')

<body class="">
  <div class="container px-6 pb-8 pt-12 h-dvh text-n900 dark:bg-n0">
    <div class="flex justify-center items-center text-center flex-col">
      <h1 class="text-2xl font-medium dark:text-white">Welcome Back!</h1>
      <p class="text-sm text-n500 dark:text-darkN500 pt-3 px-4">
       Login to you account to sell your cryptos.
      </p>
    </div>

    <!-- Login Form -->
    <form class="flex flex-col gap-4 pt-8" id="loginForm" action="{{ route('login') }}" method="POST">
      @csrf
      <div class="flex flex-col justify-start">
        <p class="text-sm font-semibold pb-2 dark:text-white">Email</p>
        <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl">
          <input type="text" name="email" placeholder="Enter email" class="w-full bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
        </div>
      </div>
      <div class="flex flex-col justify-start">
        <p class="text-sm font-semibold pb-2 dark:text-white">Password</p>
        <div class="p-4 bg-n20 border border-n40 dark:bg-darkN20 dark:border-darkN40 rounded-xl flex justify-between items-center">
          <input type="password" name="password" placeholder="Password" class="flex-1 bg-transparent outline-none placeholder:text-n90 text-sm dark:text-white" required>
          <i class="ph ph-eye-slash passowordShow cursor-pointer text-n90 text-lg !leading-none"></i>
        </div>
        <div class="flex justify-end pt-2">
          <a href="{{ route('password.email') }}" class="text-sm font-medium text-g300">Forgot password?</a>
        </div>
      </div>
      <div class="my-3 flex">
        <button type="submit" id="dash" class="flex-1 py-3 bg-g300 text-white text-center rounded-xl">Sign In</button>
      </div>
    </form>

    <div class="pt-4 text-center text-sm text-n500 dark:text-darkN500">
      Don’t have an account?
      <a href="{{ route('register') }}" class="text-g300 font-medium">Sign Up</a> here
    </div>
  </div>
@endsection

@section('scripts')

<script>
	$(document).on('click', '.passowordShow', function() {
    // Find the sibling input field
    var $passwordInput = $(this).siblings('input');
    // Check the input type
    if ($passwordInput.attr('type') === 'password') {
        $passwordInput.attr('type', 'text');
        // Change the icon class (adjust as needed for your icon library)
        $(this).removeClass('ph-eye-slash').addClass('ph-eye');
    } else {
        $passwordInput.attr('type', 'password');
        $(this).removeClass('ph-eye').addClass('ph-eye-slash');
    }
});
	$(document).ready(function() {
	  console.log("Document ready - binding login form submit event");

	  $('#loginForm').on('submit', function(e) {
		e.preventDefault(); // Prevent default full page reload
		console.log("Form submit intercepted");

		// Select the submit button
		var $button = $('#dash');
		
		// Change the button text and disable it to indicate processing
		$button.text('Processing...');
		$button.prop('disabled', true);

		$.ajax({
		  url: $(this).attr('action'),
		  method: 'POST',
		  data: $(this).serialize(),
		  headers: { 'Accept': 'application/json' },
		  success: function(response) {
			console.log("Success Response:", response);
			if (response.success) {
			  toastr.success("Login successful!", "Success", {
				timeOut: 1500,
				progressBar: true
			  });
			  setTimeout(function() {
				window.location.href = response.redirect;
			  }, 1500);
			} else {
			  toastr.error(response.message, "Login Failed", {
				timeOut: 3000,
				progressBar: true
			  });
			  // Reset button state on error
			  $button.text('Sign In');
			  $button.prop('disabled', false);
			}
		  },
		  error: function(xhr) {
			console.log("Error Response:", xhr.responseJSON);
			var message = xhr.responseJSON?.message || 'Something went wrong.';
			toastr.error(message, "Error", {
			  timeOut: 3000,
			  progressBar: true
			});
			// Reset button state on error
			$button.text('Sign In');
			$button.prop('disabled', false);
		  }
		});
	  });
	});

  </script>
@endsection
