@extends('layouts.app')
@section('content')
@include('admin.topmenu')
@include('admin.sidebar')

<div class="main-panel ">
    <div class="content ">
        <div class="page-inner">
            <div class="mt-2 mb-5 d-flex justify-content-between align-items-center">
                <h1 class="title1">Process Withdrawal Request</h1>
                <a class="btn btn-primary btn-sm" href="{{ route('mwithdrawals') }}">
                    <i class="fa fa-arrow-left"></i> Back
                </a>
            </div>

            <x-danger-alert />
            <x-success-alert />

            <div class="row mb-5">
                <div class="col-lg-8 offset-lg-2 card p-md-4 p-2 shadow">
                    <div class="mb-3">
                        @if ($withdrawal->status != 'Completed')
                            <h4>Send Funds to {{ $user->first_name }} {{ $user->last_name }} using the details below</h4>
                        @else
                            <h4 class="text-success">Payment Completed</h4>
                        @endif
                    </div>

                    <!-- Transaction Summary -->
                    <ul class="list-group mb-4">
                        <li class="list-group-item"><strong>Type:&nbsp;&nbsp;&nbsp;</strong> {{ $withdrawal->type }}</li>
                        <li class="list-group-item"><strong>Amount:&nbsp;&nbsp;&nbsp;</strong> ${{ number_format($withdrawal->amount, 2) }} ({{ $withdrawal->symbol }})</li>
                        <li class="list-group-item"><strong>Fee:&nbsp;&nbsp;&nbsp;</strong> ${{ number_format($withdrawal->fee ?? 0, 2) }}</li>
                        <li class="list-group-item"><strong>Total Deducted:&nbsp;&nbsp;&nbsp;</strong> ${{ number_format($withdrawal->amount + ($withdrawal->fee ?? 0), 2) }}</li>
                        <li class="list-group-item"><strong>Status:&nbsp;&nbsp;&nbsp;</strong>
                            @if ($withdrawal->status == 'Completed')
                                <span class="badge badge-success">{{ $withdrawal->status }}</span>
                            @elseif ($withdrawal->status == 'Rejected')
                                <span class="badge badge-danger">{{ $withdrawal->status }}</span>
                            @else
                                <span class="badge badge-warning">{{ $withdrawal->status }}</span>
                            @endif
                        </li>
                        <li class="list-group-item"><strong>Reference:&nbsp;&nbsp;&nbsp;</strong> {{ $withdrawal->ref }}</li>
                        <li class="list-group-item"><strong>Date:&nbsp;&nbsp;&nbsp;</strong> {{ \Carbon\Carbon::parse($withdrawal->created_at)->toDayDateTimeString() }}</li>
                    </ul>

                    <!-- Payment Details -->
                    <div class="mb-3 form-group">
                        @if ($withdrawal->payment_mode == 'Bank Transfer')
                            <h5>Bank Account Details</h5>
                            <input type="text" class="form-control mb-2" value="{{ $withdrawal->bank_name }}" readonly>
                            <input type="text" class="form-control mb-2" value="{{ $withdrawal->bank_account_number }}" readonly>
                            <input type="text" class="form-control" value="{{ $withdrawal->bank_account_name }}" readonly>
                        @else
                            <h5>{{ $withdrawal->symbol }} Wallet Address</h5>
                            <input type="text" class="form-control" value="{{ $withdrawal->crypto_address }}" readonly>
                        @endif
                    </div>

                    <!-- Action Form -->
                    @if ($withdrawal->status != 'Completed')
                        <div class="mt-1">
                            <form action="{{ route('pwithdrawal') }}" method="POST">
                                @csrf
                                <div class="form-group">
                                    <h6>Action</h6>
                                    <select name="action" id="action" class="mb-2 form-control">
                                        <option value="Paid">Paid</option>
                                        <option value="Reject">Reject</option>
                                    </select>
                                </div>

                                <!-- Email options -->
                                <div class="form-group d-none" id="emailcheck">
                                    <div class="selectgroup">
                                        <label class="selectgroup-item">
                                            <input type="radio" name="emailsend" id="dontsend" value="false" class="selectgroup-input" checked>
                                            <span class="selectgroup-button">Don't Send Email</span>
                                        </label>
                                        <label class="selectgroup-item">
                                            <input type="radio" name="emailsend" id="sendemail" value="true" class="selectgroup-input">
                                            <span class="selectgroup-button">Send Email</span>
                                        </label>
                                    </div>
                                </div>

                                <div class="form-group d-none" id="emailtext">
                                    <h6>Subject</h6>
                                    <input type="text" name="subject" id="subject" class="form-control">
                                    <h6 class="mt-3">Enter Reasons for rejecting this withdrawal request</h6>
                                    <textarea class="form-control" rows="3" name="reason" id="message" placeholder="Type in here..."></textarea>
                                </div>

                                <input type="hidden" name="id" value="{{ $withdrawal->id }}">
                                <button type="submit" class="btn btn-primary">Process</button>
                            </form>
                        </div>
                    @endif

                </div>
            </div>
        </div>
    </div>

<script>
    $('#action').change(function() {
        if ($(this).val() === "Reject") {
            $('#emailcheck').removeClass('d-none');
        } else {
            $('#emailcheck').addClass('d-none');
            $('#emailtext').addClass('d-none');
            $('#dontsend').prop('checked', true);
            $('#subject').removeAttr('required');
            $('#message').removeAttr('required');
        }
    });

    $('#sendemail').click(function() {
        $('#emailtext').removeClass('d-none');
        $('#subject').attr('required', true);
        $('#message').attr('required', true);
    });

    $('#dontsend').click(function() {
        $('#emailtext').addClass('d-none');
        $('#subject').removeAttr('required');
        $('#message').removeAttr('required');
    });
</script>

@endsection
