<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
} else {
    $text = 'light';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1">Manage Clients Withdrawals</h1>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row">
                    <div class="col card p-3 shadow">
                        <div class="bs-example widget-shadow table-responsive" data-example-id="hoverable-table">
                            <table id="ShipTable" class="table table-hover">
                                <thead>
                                    <tr>
                                        <th>Client Name</th>
                                        <th>Type</th>  <!-- Added Type Column -->
                                        <th>Amount Requested</th>
                                        <th>Amount + Charges</th>
                                        <th>Payment Method</th>
                                        <th>To</th>
                                        <th>Status</th>
                                        <th>Date Created</th>
                                        <th>Option</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    @foreach ($withdrawals as $withdrawal)
                                        <tr>
                                            <td>{{ $withdrawal->user->first_name }} {{ $withdrawal->user->last_name }}</td>
                                            
                                            <!-- Type Column -->
                                            <td>{{ $withdrawal->type }}</td>
                                            
                                            <td>
                                                {{ $settings->crrency }} {{ number_format($withdrawal->amount, 2) }}
                                            </td>
                                            
                                            <td>
                                                {{ $settings->crrency }} {{ number_format($withdrawal->amount + ($withdrawal->fee ?? 0), 2) }}
                                            </td>
                                            
                                            <td>{{ $withdrawal->payment_mode }}</td>
                                            
                                            <td>{{ $withdrawal->to }}</td>
                                            
                                            <td>
                                                @if ($withdrawal->status == 'Completed')
                                                    <span class="badge badge-success">{{ $withdrawal->status }}</span>
                                                @elseif ($withdrawal->status == 'Pending')
                                                    <span class="badge badge-warning">{{ $withdrawal->status }}</span>
                                                @else
                                                    <span class="badge badge-danger">{{ $withdrawal->status }}</span>
                                                @endif
                                            </td>
                                            
                                            <td>{{ $withdrawal->created_at->toDayDateTimeString() }}</td>
                                            
                                            <td>
                                                <a href="{{ route('processwithdraw', $withdrawal->id) }}" class="m-1 btn btn-info btn-sm">
                                                    <i class="fa fa-eye"></i> View
                                                </a>
                                            </td>
                                        </tr>
                                    @endforeach
                                </tbody>
                            </table>
                            
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
