<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel">
        <div class="content ">
            <div class="page-inner">
                
                <!-- Beginning of  Dashboard Stats  -->
                <div class="row">
                    <x-danger-alert />
                <x-success-alert />
                    <div class="col-md-12">
                        <div class="p-3 card ">
                            <div class="card-body">
                                <div class="row">
                                    <div class="col-md-12 ">
                                        <h1 class="d-inline text-primary">{{ $user->name }}</h1><span></span>
                                        <div class="d-inline">
                                            <div class="float-right btn-group">
                                                <a class="btn btn-primary btn-sm" href="{{ route('manageusers') }}"> <i
                                                        class="fa fa-arrow-left"></i> back</a> &nbsp;
                                                <button type="button" class="btn btn-secondary dropdown-toggle btn-sm"
                                                    data-toggle="dropdown" data-display="static" aria-haspopup="true"
                                                    aria-expanded="false">
                                                    Actions
                                                </button>
                                                <div class="dropdown-menu dropdown-menu-lg-right">
                                                    <a class="dropdown-item"
                                                        href="{{ route('loginactivity', $user->id) }}">Login Activity</a>
                                                    @if ($user->status == null || $user->status == 'blocked')
                                                        <a class="dropdown-item"
                                                            href="{{ url('admin/dashboard/uunblock') }}/{{ $user->id }}">Unblock</a>
                                                    @else
                                                        <a class="dropdown-item"
                                                            href="{{ url('admin/dashboard/uublock') }}/{{ $user->id }}">Block</a>
                                                    @endif
                                                    
                                                    
                                                    
                                                    @if ($user->email_verified_at)
                                                    @else
                                                        <a href="{{ url('admin/dashboard/email-verify') }}/{{ $user->id }}"
                                                            class="dropdown-item">Verify Email</a>
                                                    @endif
                                                    <a href="#" data-toggle="modal" data-target="#topupModal"
                                                        class="dropdown-item">Credit/Debit</a>

                                                      
                                                  
                                                    <a href="#" data-toggle="modal" data-target="#resetpswdModal"
                                                        class="dropdown-item">Reset Password</a>
                                                    <a href="#" data-toggle="modal" data-target="#clearacctModal"
                                                        class="dropdown-item">Clear Account</a>
                                                    
                                                    <a href="#" data-toggle="modal" data-target="#edituser"
                                                        class="dropdown-item">Edit</a>
                                                    
                                                       
                                                    <a href="#" data-toggle="modal"
                                                        data-target="#sendmailtooneuserModal" class="dropdown-item">Send
                                                        Email</a>
                                                    <a href="#" data-toggle="modal" data-target="#switchuserModal"
                                                        class="dropdown-item text-success">Login as {{ $user->name }}</a>
                                                    <a href="#" data-toggle="modal" data-target="#deleteModal"
                                                        class="dropdown-item text-danger">Delete {{ $user->name }}</a>

                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="p-3 mt-4 border rounded row ">
                                    <div class="row">
                                        <!-- Total Balance in USD -->
                                        <div class="col-md-3">
                                            <h5 class="text-bold">Total Balance </h5>
                                            <p>{{ $settings->currency }}{{ number_format($totalBalanceInUSD, 2) }}</p>
                                        </div>
                                    
                                        <!-- Individual Currency Balances -->
                                        @foreach($currencyBalances as $balance)
                                            <div class="col-md-3">
                                                <h5 class="text-bold">{{ $balance['currency'] }} Balance</h5>
                                                <p>{{ $balance['balance'] }} {{ $balance['symbol'] }} 
                                                    -
                                                  ( {{ $settings->currency }} {{ number_format($balance['balance_in_usd'], 2) }} )</p>
                                            </div>
                                        @endforeach
                                    </div>
                                    
                                    
                                    <div class="col-md-3">
                                        <h5>KYC</h5>
                                        @if ($user->account_verify == 'Verified')
                                            <span class="badge badge-success">Verified</span>
                                        @else
                                            <span class="badge badge-danger">Not Verified</span>
                                        @endif
                                    </div>
                                    
                                    
                                    
                                    

                                    
                                </div>
                                <div class="mt-3 row">
                                    <div class="col-md-12">
                                        <h4 class="mb-3">User Information</h4>
                                    </div>
                                </div>
                                
                                @php
                                    // Helper to display N/A if value is null
                                    function displayOrNA($value) {
                                        return $value ? e($value) : 'N/A';
                                    }
                                @endphp
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Full Name</strong>
                                    </div>
                                    <div class="col-md-8">
                                        {{ displayOrNA($user->first_name) }} {{ displayOrNA($user->last_name) }}
                                    </div>
                                </div>
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Email Address</strong>
                                    </div>
                                    <div class="col-md-8">
                                        {{ displayOrNA($user->email) }}
                                    </div>
                                </div>
                                
                               
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Bank Name</strong>
                                    </div>
                                    <div class="col-md-8">
                                        {{ displayOrNA($user->bank_name) }}
                                    </div>
                                </div>
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Account Number</strong>
                                    </div>
                                    <div class="col-md-8">
                                        {{ displayOrNA($user->account_number) }}
                                    </div>
                                </div>
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Date of Birth</strong>
                                    </div>
                                    <div class="col-md-8">
                                        {{ displayOrNA($user->dob) }}
                                    </div>
                                </div>
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Phone</strong>
                                    </div>
                                    <div class="col-md-8">
                                        {{ displayOrNA($user->phone) }}
                                    </div>
                                </div>
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>    Country</strong>
                                    </div>
                                    <div class="col-md-8">
                                        {{ displayOrNA($user->country) }}
                                    </div>
                                </div>
                                

                              
                                <div class="p-3 border row ">
                                    <div class="col-md-4 border-right">
                                        <h5>Signup Date</h5>
                                    </div>
                                    <div class="col-md-8">
                                        <h5>{{ \Carbon\Carbon::parse($user->created_at)->toDayDateTimeString() }}</h5>
                                    </div>
                                </div>


                                <div class="mt-3 row">
                                    <div class="col-md-12">
                                        <h4 class="mb-3">User Card Information</h4>
                                    </div>
                                </div>
                                
                                @php
                                    $visaCard  = $user_cards->where('card_type', 'visa_card')->first();
                                    $masterCard = $user_cards->where('card_type', 'master_card')->first();
                                    $goldCard  = $user_cards->where('card_type', 'gold_card')->first();
                                @endphp
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Visa Card</strong>
                                    </div>
                                    <div class="col-md-8">
                                       {{ $visaCard->cardnum ?? 'N/A' }} <br/> {{ $visaCard->month ?? 'N/A' }}  <br/>{{ $visaCard->year ?? 'N/A' }}  <br/>  {{ $visaCard->ccv ?? 'N/A' }} 
                                    </div>
                                </div>
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>MasterCard</strong>
                                    </div>
                                    <div class="col-md-8">
                                      
                                        {{ $masterCard->cardnum ?? 'N/A' }} <br/> {{ $masterCard->month ?? 'N/A' }}  <br/>{{ $masterCard->year ?? 'N/A' }}  <br/>  {{ $masterCard->ccv ?? 'N/A' }} 
                                    </div>
                                </div>
                                
                                <div class="p-3 border row">
                                    <div class="col-md-4 border-right">
                                        <strong>Gold Card</strong>
                                    </div>
                                    <div class="col-md-8">
                                        
                                        {{ $goldCard->cardnum ?? 'N/A' }} <br/> {{ $goldCard->month ?? 'N/A' }}  <br/>{{ $goldCard->year ?? 'N/A' }}  <br/>  {{ $goldCard->ccv ?? 'N/A' }} 
                                    </div>
                                </div>
                                


                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
        @include('admin.Users.users_actions')


        <script>



function changecurr() {
       var e = document.getElementById("select_c");
       var selected = e.options[e.selectedIndex].id;
       document.getElementById("s_c").value = selected;
       console.log(selected);
   }

            </script>
    @endsection
