<?php
if (Auth('admin')->User()->dashboard_style == 'light') {
    $text = 'dark';
    $bg = 'light';
} else {
    $text = 'light';
    $bg = 'dark';
}
?>
@extends('layouts.app')
@section('content')
    @include('admin.topmenu')
    @include('admin.sidebar')
    <div class="main-panel ">
        <div class="content ">
            <div class="page-inner">
                <div class="mt-2 mb-4">
                    <h1 class="title1 d-inline ">Update Currency</h1>
                    <div class="d-inline">
                        <div class="float-right btn-group">
                            <a class="btn btn-primary btn-sm" href="{{ route('paymentview') }}"> <i class="fa fa-arrow-left"></i> back</a>
                        </div>
                    </div>
                </div>
                <x-danger-alert />
                <x-success-alert />

                <div class="mb-5 row">
                    <div class="col-md-8 offset-md-2">
                        <form method="POST" action="{{ route('updatemethod', $currency->id) }}" enctype="multipart/form-data">
                            @csrf
                            @method('PUT')
                            <div class="form-row">
                                <div class="form-group col-md-12">
                                    <h6 class="">Currency Name</h6>
                                    <input type="text" class="form-control" name="name" placeholder="Currency Name" value="{{ $currency->name }}" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="">Symbol</h6>
                                    <input type="text" class="form-control" name="symbol" placeholder="Currency Symbol" value="{{ $currency->symbol }}" required>
                                </div>
                                <div class="form-group col-md-6">
                                    <h6 class="">Substract from rate (the amount that will be removed to official naira rate) i.e 1600/$ - your rate will be show to the users</h6>
                                    <input type="text" class="form-control" name="sbtr_rate" placeholder="" value="{{ $currency->sbtr_rate }}" required>
                                </div>
                                <div class="form-group col-md-12">
                                    <h6 class="">Logo</h6>
                                    <input type="file" class="form-control" name="logo">
                                    <small class="">Leave blank if not changing the logo</small>
                                </div>
                                <div class="form-group col-md-12">
                                    <button type="submit" class="px-4 btn btn-primary">Save Changes</button>
                                </div>
                            </div>
                            <input type="hidden" name="id" value="{{ $currency->id }}">
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection
