const CACHE_NAME = 'virus-pwa-cache-v1';
const urlsToCache = [
    '/',
    '/offline',  // Optional: Custom offline page
    '/css/app.css',
    '/js/app.js',
    '/images/logo.png',
    // Add more assets you want to cache
];

// Install Event - Caching App Shell
self.addEventListener('install', event => {
    event.waitUntil(
        caches.open(CACHE_NAME)
            .then(cache => {
                console.log('Opened cache');
                return cache.addAll(urlsToCache);
            })
    );
});

// Fetch Event - Serve from Cache, Fallback to Network
self.addEventListener('fetch', event => {
    event.respondWith(
        caches.match(event.request)
            .then(response => {
                // Return cached response if found
                if (response) {
                    return response;
                }
                return fetch(event.request);
            })
            .catch(() => {
                // If both cache & network fail, show offline page if request is for a page
                if (event.request.mode === 'navigate') {
                    return caches.match('/offline');
                }
            })
    );
});

// Activate Event - Clean Old Caches
self.addEventListener('activate', event => {
    event.waitUntil(
        caches.keys().then(cacheNames => {
            return Promise.all(
                cacheNames.map(cacheName => {
                    if (cacheName !== CACHE_NAME) {
                        return caches.delete(cacheName);
                    }
                })
            );
        })
    );
});
