<?php
namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class UserWallet extends Model
{
    protected $fillable = ['user_id', 'currency_id', 'balance', 'address', 'xprv_key'];

    public function currency()
    {
        return $this->belongsTo(Currency::class, 'currency_id');
    }
public function deposits() { return $this->hasMany(Deposit::class, 'user_wallet_id'); }
public function withdrawals() { return $this->hasMany(Withdrawal::class, 'user'); }
}

