<?php

namespace App\Models;

use App\Models\User;
use App\Models\UserWallet;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class Deposit extends Model
{
    use HasFactory;

    protected $fillable = [
        'user_wallet_id',
        'user_id',
        'amount',
        'from_address',
        'hash',
        'payment_mode',
        'status',
        'time',
        'created_at',
        'updated_at',
    ];
    
    public function userWallet()
    {
        return $this->belongsTo(UserWallet::class, 'user_wallet_id');
    }
    public function duser(){
    	return $this->belongsTo(User::class, 'user_wallet_id');
    }
    
    public function wallet()
    {
        return $this->userWallet();
    }
}