<?php
// app/Models/Copytrader.php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

class CopyTrader extends Model
{
    protected $table = 'copytraders'; // This should match your database table name
    
    use HasFactory;

    // Add the fields that are mass assignable
    protected $fillable = [
        'name',
        'level',
        'minimum',
        'followers',
        'percent_profit',
        'total_profit',
        'tcode',
        'rating',
        'profile_pic',
        'bg',
        'bio',
    ];
    
     public function users()
{
    return $this->belongsToMany(User::class, 'copytrader_user', 'copytrader_id', 'user_id');
}
}

