<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Model;

class Contact extends Model
{
    protected $fillable = [
        'user_id',
        'name',
        'type',
        'wallet_address',
        'bank_name',
        'bank_account_number',
        'routing_number',
        'account_type',
        'details',
        'country',
        'currency',
    ];

    protected $casts = [
        'details' => 'array',
    ];

    public function user()
    {
        return $this->belongsTo(User::class);
    }
}
