<?php
namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Mail\Mailable;
use Illuminate\Queue\SerializesModels;

class NewNotification extends Mailable
{
    use Queueable, SerializesModels;

    public $url, $attachment, $body, $subject, $recipient, $salutation;

    /**
     * Create a new message instance.
     */
    public function __construct($body, $subject, $recipient = null, $url = null, $attachment = null, $salutation = null)
    {
        $this->url = $url;
        $this->attachment = $attachment;
        $this->body = $body;
        $this->subject = $subject;
        $this->recipient = $recipient;
        $this->salutation = $salutation;
    }

    /**
     * Build the message.
     */
    public function build()
    {
        return $this->markdown('emails.NewNotification', [
                'url'            => $this->url,
                'attachment'     => $this->attachment,
                'messageContent' => $this->body,
                'subject'        => $this->subject,
                'recipient'      => $this->recipient,
                'salutation'     => $this->salutation,
            ])
            ->subject($this->subject);
    }
}
