<?php

namespace App\Mail;

use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Mail\Mailable;
use Illuminate\Mail\Mailables\Content;
use Illuminate\Mail\Mailables\Envelope;
use Illuminate\Queue\SerializesModels;

class ContactTransferSuccess extends Mailable
{
    public $user, $contact, $amount, $currency;

    public function __construct($user, $contact, $amount, $currency)
    {
        $this->user = $user;
        $this->contact = $contact;
        $this->amount = $amount;
        $this->currency = $currency;
    }

    public function build()
    {
        return $this->subject('Transfer Successful')
                    ->view('emails.contact-transfer-success');
    }
}
