<?php

namespace App\Http\Controllers\User;

use App\Models\User;
use App\Models\CopyTrader;
use App\Models\Settings;
use Illuminate\Support\Facades\Validator;
use App\Http\Controllers\Controller;
use Illuminate\Support\Facades\Auth;
use Illuminate\Http\Request;
use App\Mail\NewNotification;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\DB;
use GuzzleHttp\Client;

class UsersController extends Controller

{
    
  public function verifyemail()
  {
    return view('auth.verify-email', [
      'title' => 'Verify Your email address',
    ]);
  }
  public function addusername(Request $request)
  {
    Validator::make($request, [
      'username' => ['required', 'unique:users,username'],
    ])->validate();

    User::where('id', Auth::user()->id)->update([
      'username' => $request['username'],
    ]);
    return redirect()->route('dashboard');
  }

  public function sendcontact(Request $request)
  {

    $settings = Settings::where('id', '1')->first();

    $message = "$request->message";
    $subject = "Inquiry from $request->name with email $request->email";


    Mail::to($settings->contact_email)->send(new NewNotification($message, $subject, 'Admin'));

    return redirect()->back()
      ->with('success', ' Your message was sent successfully!');
  }

}
 