<?php

namespace App\Http\Controllers\Auth;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Log;
use App\Mail\LoginEmail;
use Jenssegers\Agent\Agent;
use App\Mail\NewNotification;
use App\Models\User;


class LoginController extends Controller
{

    public function login(Request $request)
{
    $request->validate([
        'email'    => 'required|string|email',
        'password' => 'required|string',
    ]);

    $credentials = $request->only('email', 'password');

    if (!Auth::attempt($credentials)) {
        return response()->json(['success' => false, 'message' => 'Invalid credentials.'], 401);
    }

    $user = Auth::user();

    if ($user->loginotp === 'yes') {
     
        $otpCode = rand(1000, 9999);

       
        DB::table('otp')->updateOrInsert(
            ['user_id' => $user->id],
            ['code' => $otpCode, 'expires_at' => now()->addMinutes(10)]
        );

        Mail::to($user->email)->send(new NewNotification(
            "Your OTP code is <b>{$otpCode}</b>. It expires in 10 minutes.",
            'Your Login OTP Code',
            $user->first_name
        ));

        Auth::logout();

        return response()->json([
            'success'  => true,
            'message'  => 'OTP sent to your email. Please verify.',
            'redirect' => route('otp', ['email' => $user->email])
        ]);
    }


    $request->session()->regenerate();

    $agent = new Agent();
    $loginTime = now();

    DB::table('activities')->insert([
        'user'       => $user->id,
        'ip_address' => $request->ip(),
        'device'     => $agent->device(),
        'browser'    => $agent->browser(),
        'os'         => $agent->platform(),
        'created_at' => $loginTime,
        'updated_at' => $loginTime,
    ]);

    Mail::to($user->email)->send(new LoginEmail(
        $user,
        $request->ip(),
        $agent->device(),
        $agent->browser(),
        $agent->platform(),
        $loginTime
    ));

    return response()->json([
        'success'  => true,
        'message'  => 'Login successful!',
        'redirect' => route('dashboard')
    ]);
}




public function verifyOtp(Request $request)
{
    $data = $request->validate([
        'email' => 'required|email',
        'otp'   => 'required|digits:4',
    ]);

    $user = User::where('email', $data['email'])->firstOrFail();

    $otpRecord = DB::table('otp')
        ->where('user_id', $user->id)
        ->where('code', $data['otp'])
        ->where('expires_at', '>=', now())
        ->first();

    if (!$otpRecord) {
        return response()->json(['success' => false, 'message' => 'Invalid or expired OTP.'], 422);
    }

    Auth::login($user);
    $request->session()->regenerate();

    $agent = new Agent();
    $loginTime = now();

    DB::table('activities')->insert([
        'user'       => $user->id,
        'ip_address' => $request->ip(),
        'device'     => $agent->device(),
        'browser'    => $agent->browser(),
        'os'         => $agent->platform(),
        'created_at' => $loginTime,
        'updated_at' => $loginTime,
    ]);

    Mail::to($user->email)->send(new LoginEmail(
        $user,
        $request->ip(),
        $agent->device(),
        $agent->browser(),
        $agent->platform(),
        $loginTime
    ));

    DB::table('otp')->where('user_id', $user->id)->delete();

    return response()->json([
        'success'  => true,
        'message'  => 'Login successful!',
        'redirect' => route('dashboard')
    ]);
}


public function otp()
{
    return view('auth.verifyotp', ['title' => 'Verify OTP']);
}





    
}
