<?php


namespace App\Http\Controllers\Admin\Settings;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use App\Models\Currency; // Use Currency model
use App\Models\User; // Use Currency model
use App\Models\UserWallet; // Use Currency model
use Illuminate\Support\Facades\Storage;
use App\Models\ConnectWallet;

class PaymentController extends Controller
{

   
    
        
        
    // Return view with list of currencies
    public function paymentview(Request $request)
    {
        $currencies = Currency::orderByDesc('id')->get();

        return view('admin.Settings.PaymentSettings.show', [
            'title' => 'Currency Settings',
            'currencies' => $currencies,
        ]);
    }

   // Add new currency
public function addpaymethod(Request $request)
{
    $this->validate($request, [
        'name' => 'required|string|max:255',
        'symbol' => 'required|string|max:10',
        'sbtr_rate' => 'required|string|max:255',
        'logo' => 'image|mimes:jpg,jpeg,png|max:500', // Ensure valid logo
    ]);

    // Handle logo upload
    if ($request->hasfile('logo')) {
        $file = $request->file('logo');
        $path = $file->store('coin', 'public');
    } else {
        $path = null;
    }

    // Create a new currency record
    $currency = new Currency();
    $currency->name = $request['name'];
    $currency->symbol = $request['symbol'];
    $currency->sbtr_rate = $request['sbtr_rate'];
    $currency->logo = $path;
    $currency->save();

    // Loop through all users and create a new UserWallet for each user
    $users = User::all(); // Get all users

    foreach ($users as $user) {
        $userWallet = new UserWallet();
        $userWallet->user_id = $user->id;
        $userWallet->currency_id = $currency->id; // Link to the newly added currency
        $userWallet->balance = 0; // Default balance set to 0
        $userWallet->save();
    }

    return redirect()->back()->with('success', 'Currency Added and User Wallets Created Successfully');
}

    // Edit an existing currency
    public function editmethod($id)
    {
        $currency = Currency::where('id', $id)->first();

        return view('admin.Settings.PaymentSettings.editpaymethod', [
            'title' => 'Update Currency',
            'currency' => $currency,
        ]);
    }

    // Update an existing currency
    public function updatemethod(Request $request)
    {
        $this->validate($request, [
            'name' => 'required|string|max:255',
            'symbol' => 'required|string|max:10',
            'sbtr_rate' => 'required|string|max:255',
            'logo' => 'image|mimes:jpg,jpeg,png|max:500',
        ]);

        $currency = Currency::where('id', $request->id)->first();

        // Handle logo upload if provided
        if ($request->hasfile('logo')) {
            $file = $request->file('logo');
            if (Storage::disk('public')->exists($currency->logo)) {
                Storage::disk('public')->delete($currency->logo);
            }
            $path = $file->store('coin', 'public');
        } else {
            $path = $currency->logo;
        }

        // Update currency details
        Currency::where('id', $request->id)->update([
            'name' => $request['name'],
            'symbol' => $request['symbol'],
            'sbtr_rate' => $request['sbtr_rate'],
            'logo' => $path,
        ]);

        return redirect()->back()->with('success', 'Currency Updated Successfully');
    }

    // Delete a currency
    public function deletepaymethod($id)
    {
        $currency = Currency::where('id', $id)->first();

        if (Storage::disk('public')->exists($currency->logo)) {
            Storage::disk('public')->delete($currency->logo); // Delete logo if exists
        }

        Currency::where('id', $id)->delete();
        return redirect()->back()->with('success', 'Currency Deleted Successfully');
    }

    // Enable or disable a currency (if needed)
    public function togglePaymentMethodStatus(int $id)
    {
        $currency = Currency::where('id', $id)->first();

        if ($currency->status == 'enabled') {
            Currency::where('id', $id)->update([
                'status' => 'disabled',
            ]);
        } else {
            Currency::where('id', $id)->update([
                'status' => 'enabled',
            ]);
        }

        return redirect()->back()->with('success', 'Currency Status Updated');
    }
}
