<?php

namespace App\Http\Controllers\Admin;

use App\Http\Controllers\Controller;
use App\Models\User;
use App\Models\Settings;
use App\Models\Admin;
use App\Models\Asset;
use App\Models\Deposit;
use App\Models\Wdmethod;
use App\Models\Transaction;
use App\Models\Cp_transaction;
use Illuminate\Support\Facades\DB;
use Illuminate\Http\Request;
use App\Models\Kyc;
use Illuminate\Support\Facades\Cache;

class HomeController extends Controller
{
    /**
     * Show Admin Dashboard.
     * 
     * @return \Illuminate\Http\Response
     */
    public function index()
    {
        $total_deposited = DB::table('transactions')
            ->where('type', 'LIKE', '%Deposit%')
            ->where('status', 'Processed')
            ->sum('amount');
    
        $pending_deposited = DB::table('transactions')
            ->where('type', 'LIKE', '%Deposit%')
            ->where('status', 'Pending')
            ->sum('amount');
    
        $total_withdrawn = DB::table('transactions')
            ->where('type', 'LIKE', '%Withdraw%')
            ->where('status', 'Processed')
            ->sum('amount');
    
        $pending_withdrawn = DB::table('transactions')
            ->where('type', 'LIKE', '%Withdraw%')
            ->where('status', 'Pending')
            ->sum('amount');
    
        $userlist = User::count();
        $activeusers = User::where('status', 'active')->count();
        $blockeusers = User::where('status', 'blocked')->count();
        $unverifiedusers = User::where('account_verify', '!=', 'yes')->count();
    
        $chart_pdepsoit = $total_deposited;
        $chart_pendepsoit = $pending_deposited;
        $chart_pwithdraw = $total_withdrawn;
        $chart_pendwithdraw = $pending_withdrawn;
    
        return view('admin.dashboard', [
            'title'              => 'Admin Dashboard',
            'total_deposited'    => $total_deposited,
            'pending_deposited'  => $pending_deposited,
            'total_withdrawn'    => $total_withdrawn,
            'pending_withdrawn'  => $pending_withdrawn,
            'user_count'         => $userlist,
            'chart_pdepsoit'     => $chart_pdepsoit,
            'chart_pendepsoit'   => $chart_pendepsoit,
            'chart_pwithdraw'    => $chart_pwithdraw,
            'chart_pendwithdraw' => $chart_pendwithdraw,
            'activeusers'        => $activeusers,
            'blockeusers'        => $blockeusers,
            'unverifiedusers'    => $unverifiedusers,
        ]);
    }
    
   

   

    //ennd signals
    //Return manage users route
    public function manageusers()
    {
        return view('admin.Users.users')
            ->with(array(
                'title' => 'All users',

            ));
    }



    // Return search route for Withdrawals
public function searchWt(Request $request)
{
    $searchItem = $request->input('wtquery');

    $result = Transaction::where('type', 'LIKE', '%Withdrawal%')
        ->where(function($query) use ($searchItem) {
            $query->where('user', 'LIKE', "%{$searchItem}%")
                  ->orWhere('amount', $searchItem)
                  ->orWhere('payment_mode', 'LIKE', "%{$searchItem}%")
                  ->orWhere('status', 'LIKE', "%{$searchItem}%");
        })
        ->with('duser')
        ->orderBy('id', 'desc')
        ->paginate(10);

    return view('admin.Withdrawals.mwithdrawals', [
        'title'       => 'Withdrawals Search Result',
        'withdrawals' => $result
    ]);
}

// Return manage withdrawals route
public function mwithdrawals()
{
    $withdrawals = Transaction::where(function($query) {
        $query->where('type', 'LIKE', '%Withdrawal%')
              ->orWhere('type', 'LIKE', '%Send to Contact%')
              ->orWhere('type', 'LIKE', '%Buy Crypto%')
              ->orWhere('type', 'LIKE', '%Bills Payment%');
    })
    ->with('duser')
    ->orderBy('id', 'desc')
    ->paginate(15);  // Pagination for better performance

    return view('admin.Withdrawals.mwithdrawals', [
        'title'       => 'Manage Users Withdrawals, Crypto Purchases & Bill Payments',
        'withdrawals' => $withdrawals
    ]);
}


// Return manage deposits route
public function mdeposits()
{
    $deposits = Transaction::where('type', 'LIKE', '%Deposit%')
        ->with('duser')
        ->orderBy('id', 'desc')
        ->paginate(15);

    return view('admin.Deposits.mdeposits', [
        'title'    => 'Manage Users Deposits',
        'deposits' => $deposits
    ]);
}




    public function emailServices()
    {
        return view('admin.email.index', [
            'title' =>  "Email services"
        ]);
    }


    


 

    public function adduser()
    {
        return view('admin.referuser')->with(array(
            'title' => 'Add new Users',
            'settings' => Settings::where('id', '=', '1')->first()
        ));
    }

    public function addmanager()
    {
        return view('admin.addadmin')->with(array(
            'title' => 'Add new manager',
            'settings' => Settings::where('id', '=', '1')->first()
        ));
    }
    public function madmin()
    {
        return view('admin.madmin')->with(array(
            'admins' => Admin::orderby('id', 'desc')->get(),
            'title' => 'Add new manager',


        ));
    }

    //Return KYC route
    public function kyc()
    {
        return view('admin.kyc', [
            'title' => 'KYC Applications',
            'kycs' => Kyc::orderByDesc('id')->with(['user'])->get(),
        ]);
    }

    public function viewKycApplication($id)
    {

        return view('admin.kyc-applications', [
            'title' => 'View KYC Application',
            'kyc' => Kyc::where('id', $id)->with(['user'])->first(),
        ]);
    }

    public function adminprofile()
    {
        return view('admin.Profile.profile')
            ->with(array(
                'title' => 'Admin Profile',


            ));
        }
  
}
