<?php

namespace App\Helpers;

use App\Models\UserWallet;
use App\Models\CryptoPrice;
use Illuminate\Support\Facades\Auth;

class WalletHelper
{
    public static function getSubtractedRate($userId, $currencySymbol)
    {
        $wallet = UserWallet::where('user_id', $userId)
            ->whereHas('currency', function ($query) use ($currencySymbol) {
                $query->where('symbol', $currencySymbol);
            })->with('currency')->first();

        if (!$wallet || !$wallet->currency) {
            return 0;
        }

        $nairaPrice = CryptoPrice::where('crypto_name', 'naira')->value('price');

        return $nairaPrice - $wallet->currency->sbtr_rate;
    }
}
