<?php

namespace App\Console\Commands;

use Illuminate\Console\Command;
use App\Models\UserWallet;
use App\Services\TatumService;
use Illuminate\Support\Facades\Log;

class ScanUserWalletsTransactions extends Command
{
    protected $signature = 'wallets:scan-transactions';
    protected $description = 'Loop through all user wallets and run getWalletTransactions() for each';

    public function handle()
    {
        Log::info("Wallet transactions scan started.");
        $wallets = UserWallet::with('currency')->get();
        $tatumService = app(TatumService::class);

        foreach ($wallets as $wallet) {
            $symbol = strtoupper(trim($wallet->currency->symbol));
            $address = $wallet->address;
            Log::info("Scanning wallet ID {$wallet->id} ({$address}) for symbol: {$symbol}");

            $transactions = $tatumService->getWalletTransactions($address, $symbol, $wallet);
            if (empty($transactions)) {
                Log::info("No new transactions found for wallet ID {$wallet->id}.");
            } else {
                Log::info("Found " . count($transactions) . " transactions for wallet ID {$wallet->id}.");
                // Optionally, process transactions here if needed
            }
        }

        Log::info("Wallet transactions scan completed.");
        return 0;
    }
}
