<?php
namespace App\Channels;

use Illuminate\Notifications\Notification;
use Illuminate\Support\Facades\Http;
use Illuminate\Support\Facades\Log;

class TermiiChannel
{
    public function send($notifiable, Notification $notification)
    {
        if (!method_exists($notification, 'toTermii')) {
            Log::warning('TermiiChannel: toTermii() method missing in notification.');
            return;
        }

        $message = $notification->toTermii($notifiable);

        try {
            $response = Http::post('https://v3.api.termii.com/api/sms/send', [
                'to' => $message['to'],
                'from' => $message['from'],
                'sms' => $message['body'],
                'type' => 'plain',
                'channel' => 'generic',
                'api_key' => env('TERMII_API_KEY'),
            ]);

            $json = $response->json();

            Log::error('Termii SMS raw response', [
                'body' => $response->body(),
                'status' => $response->status()
            ]);
            

            if ($response->successful()) {
                Log::info('Termii SMS sent successfully', [
                    'to' => $message['to'],
                    'from' => $message['from'],
                    'body' => $message['body'],
                    'response' => $json,
                ]);
            } else {
                Log::error('Termii SMS failed', [
                    'to' => $message['to'],
                    'from' => $message['from'],
                    'body' => $message['body'],
                    'response' => $json,
                ]);
            }
        } catch (\Throwable $e) {
            Log::error('TermiiChannel Exception', [
                'to' => $message['to'],
                'from' => $message['from'],
                'body' => $message['body'],
                'error' => $e->getMessage(),
            ]);
        }
    }
}