<?php

namespace App\Actions\Fortify;

use App\Mail\WelcomeEmail;
use App\Models\User;
use App\Models\Settings;
use App\Models\UserWallet;
use App\Models\Currency;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Validator;
use Laravel\Fortify\Contracts\CreatesNewUsers;
use Illuminate\Support\Facades\Mail;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Http;
use App\Http\Controllers\WalletController;

class CreateNewUser implements CreatesNewUsers
{
    use PasswordValidationRules;

    /**
     * Validate and create a newly registered user.
     *
     * @param  array  $input
     * @return \App\Models\User
     */
    public function create(array $input)
    {
        $settings = Settings::where('id', '1')->first();

        // Validation logic
        if ($settings->captcha == "true") {
            Validator::make($input, [
                'email' => ['required', 'string', 'email', 'max:55', 'unique:users'],
                'password' => $this->passwordRules(),
            ])->validate();
        } else {
            Validator::make($input, [
                'email' => ['required', 'string', 'email', 'max:255', 'unique:users'],
                'password' => $this->passwordRules(),
            ])->validate();
        }


        // Create user
        $user = User::create([
            'email' => $input['email'],
            'status' => 'active',
            'password' => Hash::make($input['password']),
        ]);

        // Create wallets with BlockCypher subwallet addresses via HTTP
        (new WalletController())->createWalletsForUser($user->id);

        // Send welcome email
        Mail::to($user->email)->send(new WelcomeEmail($user));

        return $user;
    }

}